/* ea.cpp:  some EA manipulation routines 

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ea.hpp"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>

// return a number relating to last file write time
long query_last_write(char *filename) {
    HFILE infile;
    ULONG result=0;
    FILESTATUS3 fi;
    long t;
    APIRET rc;

    rc=DosOpen(filename,
	       &infile,
	       &result,
	       0,
	       0,
	       OPEN_ACTION_FAIL_IF_NEW|
	       OPEN_ACTION_OPEN_IF_EXISTS,
	       OPEN_SHARE_DENYNONE,
	       0);
	    
    if ((rc) && (result)) return(0);

    DosQueryFileInfo(infile,
		     FIL_STANDARD,
		     &fi,
		     sizeof(fi));

    DosClose(infile);

    t=fi.ftimeLastWrite.twosecs +
	(30 * fi.ftimeLastWrite.minutes) +
	(30 * 60 * fi.ftimeLastWrite.hours) +
	(30 * 60 * 24 * fi.fdateLastWrite.day) +
	(30 * 60 * 24 * 31 * fi.fdateLastWrite.month) +
	(30 * 60 * 24 * 31 * 12 * fi.fdateLastWrite.year);

    return(t);
}

// get binary ea data from file
int getEA(char *filename, char *eaname, PVOID ea, long *maxeasize) {
    HFILE infile;
    ULONG result=0;
    FILESTATUS4 fi;
    APIRET rc;
    FEA2LIST *flist;
    GEA2LIST *glist;
    EAOP2 eaop2;
    int i;

    // get a file handle
    rc=DosOpen(filename,
	       &infile,
	       &result,
	       0,
	       0,
	       OPEN_ACTION_FAIL_IF_NEW|
	       OPEN_ACTION_OPEN_IF_EXISTS,
	       OPEN_SHARE_DENYNONE,
	       0);
    if (rc) return(1);

    // get total size of ea list from fileinfo.
    rc = DosQueryFileInfo(infile,
			  FIL_QUERYEASIZE,
			  &fi,
			  sizeof(fi));
    if (rc) {
	DosClose(infile);
	return(1);
    }

    // allocate maximum memory that could be required.
    flist = (FEA2LIST *)malloc(2*fi.cbList);
    glist = (GEA2LIST *)malloc(2*fi.cbList);

    glist->cbList = 1;   
    glist->list[0].oNextEntryOffset=0;
    glist->list[0].cbName = strlen(eaname);
    strcpy(glist->list[0].szName,eaname);

    flist->cbList = 2*fi.cbList;

    eaop2.fpGEA2List = glist;
    eaop2.fpFEA2List = flist;
    eaop2.oError = 0;
    
    // load ea info into buffer
    rc = DosQueryFileInfo(infile,
			  FIL_QUERYEASFROMLIST,
			  &eaop2,
			  sizeof(eaop2));
    if (rc) {
	free(flist);
	free(glist);
	DosClose(infile);
	return(1);
    }

    // make sure ea isn't larger than buffer
    *maxeasize = min(*maxeasize,
		     flist->list[0].cbValue);
    // and copy it.
    memcpy(ea,
	   flist->list[0].szName+flist->list[0].cbName+1,
	   *maxeasize);
	   
    free(flist);
    free(glist);
    DosClose(infile);
    if (*maxeasize) return(0);
    else return(1);
}

// put binary ea data into file
int putEA(char *filename, char *eaname, PVOID ea, long easize) {
    HFILE infile;
    ULONG result=0;
    FILESTATUS4 fi;
    APIRET rc;
    EAOP2 eaop2;
    int i;
    size_t blocks;
    FEA2LIST *flist=NULL;

    blocks = sizeof(FEA2LIST) + strlen(eaname) + easize;
    flist = (FEA2LIST *)malloc(blocks);
    flist->cbList = sizeof(FEA2LIST) + strlen(eaname) + easize;
    flist->list[0].oNextEntryOffset = 0;
    flist->list[0].fEA = 0;
    flist->list[0].cbName = strlen(eaname);
    flist->list[0].cbValue = easize;
    memcpy(flist->list[0].szName,
	   eaname,
	   flist->list[0].cbName);
    memcpy(flist->list[0].szName+flist->list[0].cbName+1,
	   ea,
	   easize);

    eaop2.fpGEA2List = NULL;
    eaop2.fpFEA2List = flist;
    eaop2.oError = 0;
    
    // get the file handle
    rc=DosOpen(filename,
	       &infile,
	       &result,
	       0,
	       0,
	       OPEN_ACTION_FAIL_IF_NEW|
	       OPEN_ACTION_OPEN_IF_EXISTS,
	       OPEN_SHARE_DENYNONE|
	       OPEN_ACCESS_READWRITE,
	       &eaop2);
    if (rc) {
	free(flist);
	return(1);
    }

    // set file info using eaop2 structure
    rc = DosSetFileInfo(infile,
			FIL_QUERYEASIZE,
			&eaop2,
			sizeof(eaop2));
    free(flist);
    DosClose(infile);
    if (rc) return(1);

    return(0);
}


