/* bookwin.cpp:  Spellbook control program

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define INCL_WIN
#include <os2.h>
#include "splhelp.hpp"
#include "spldlg.h"

extern HWND hwndhelp;
extern HWND hwndspellhelp;

// create a general help instances hwndhelp and hwndspellhelp.
void init_help(HAB hab) {
    HELPINIT hi;

    // set up helpinit
    hi.cb = sizeof(HELPINIT);
    hi.ulReturnCode = 0;
    hi.pszTutorialName = NULL;
    hi.hmodHelpTableModule = NULLHANDLE;
    hi.hmodAccelActionBarModule = 0;
    hi.idAccelTable = 0;
    hi.idActionBar = 0;
    hi.phtHelpTable = (PHELPTABLE)MAKEULONG(BOOKMENU,0xFFFF);
    hi.pszHelpWindowTitle = (PSZ)"Spellbook Help";
    hi.pszHelpLibraryName = (PSZ)"spl.hlp";
    hi.fShowPanelId = CMIC_HIDE_PANEL_ID;
    
    hwndhelp = WinCreateHelpInstance(hab,&hi);

    if (hwndhelp && hi.ulReturnCode) {
	WinDestroyHelpInstance(hwndhelp);
	hwndhelp = NULL;
    }

    hi.ulReturnCode=0;
    hi.phtHelpTable = (PHELPTABLE)MAKEULONG(SPELLMENU,0xFFFF);

    hwndspellhelp = WinCreateHelpInstance(hab,&hi);

    if (hwndspellhelp && hi.ulReturnCode) {
	WinDestroyHelpInstance(hwndspellhelp);
	hwndspellhelp = NULL;
    }

    if ((hwndhelp==NULL) || (hwndspellhelp==NULL)) {
	// complain about help not being available
	WinMessageBox(HWND_DESKTOP,
		      HWND_DESKTOP,
		      (PSZ)"Help Not Available",
		      (PSZ)"Couldn't find SPL.HLP",
		      102,
		      MB_OK | MB_ICONEXCLAMATION);
    }
}
