/* splobj.cpp:

  working thread and object window for spellbook class
  bookwindow procedures mainly called by object window go in here

    Copyright (C) 1993, 1994 John-Marc Chandonia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "spl.hpp"
#include "general.hpp"
#include "spldlg.h"
#include "bookwin.hpp"
#include "splwin.hpp"
#include "spldlgs.hpp"
#include "ea.hpp"

// stuff needed from spl.cpp
extern char master_name[256];
extern char quick_master_name[256];
extern spellbook *masterlist;
extern HEV sem_object_started;
extern HEV sem_master_loading;
extern BYTE xfer_buffer[10240];

// bookwindow currently being created: from threadmain(f)
bookwindow *first;

// set window to a given spellbook
boolean bookwindow::set_spellbook(spellbook *x) {
    spellrecord *deleteme;
    spelllist *i;
    char buffer[256];

    // clear old spellbook, and window
    while (deleteme=(spellrecord *)
	   WinSendMsg(hwndcnr,
		      CM_QUERYRECORD,
		      0,
		      MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER)))
	   delete_spell(deleteme);
	   
    // add new spells to my window, at end.
    add_all_spells(x);

    // change name of book to book just read.
    if (x->name) {
	delete (sb->name);
	sb->name=strdup(x->name);
    }
    
    refresh();

    saved=true;
    return(true);
}

// add all spells in a spellbook, efficiently
boolean bookwindow::add_all_spells(spellbook *b, spellrecord *where) {
    spelllist *sl;
    spellrecord *sr;
    int nspells=0;
    spellrecord *newrecords;
    LONG extrabytes;
    HPOINTER myicon;
    priestspell *ps;
    int i;

/* inefficient way:
    for (sl=b->first; sl!=NULL; sl=sl->next)
	add_spell(sl->s);
*/

    for (sl=b->first; sl!=NULL; sl=sl->next)
	nspells++;

    if (nspells==0) return(true);

    extrabytes=(LONG)(sizeof(spellrecord)-sizeof(RECORDCORE));
    // tell the container to allocate memory for new records
    newrecords=(spellrecord *)WinSendMsg(hwndcnr,
					 CM_ALLOCRECORD,
					 MPFROMLONG(extrabytes),
					 (MPARAM)nspells);
    sr=newrecords;
    // set up each record
    for (sl=b->first; sl!=NULL; sl=sl->next) {
	sr->core.flRecordAttr=0;
	sr->s=sl->s;
	sr->level = (ULONG)sl->s->level;
	ps = (priestspell *)sl->s;
	sr->cast = ps->casttime;
	sr->range = ps->range;
	sr->duration = ps->duration;
	sr->area = ps->area;
	if (sl->s->type=='M')
	    sr->sphereschool = ps->school;
	else 
	    sr->sphereschool = ps->sphere;
	sr->components = ps->components;    
	sr->save = ps->save;
	sr->core.pszIcon=(PSZ)sl->s->name;
	sr->core.pszText=(PSZ)sl->s->name;
	sr->core.pszName=(PSZ)sl->s->name;
	myicon=lookup_icon(sl->s);
	sr->core.hptrIcon=myicon;
	sr->core.hptrMiniIcon=myicon;

	// add to spellbook, also
	if (where==NULL)  // add at end.
	    sr->spl = sb->add_spell(*(sl->s), sb->last);
	else  // add after where
	    sr->spl = sb->add_spell(*(sl->s), where->spl);

	sr=(spellrecord *)sr->core.preccNextRecord;
    }
	    
    // tell the container to add the records
    RECORDINSERT ri;
    ri.cb=sizeof(RECORDINSERT);
    if (where==NULL) 
	ri.pRecordOrder=(PRECORDCORE)CMA_END;
    else
	ri.pRecordOrder=&(where->core);
    ri.pRecordParent=NULL;
    ri.fInvalidateRecord=FALSE;
    ri.zOrder=CMA_TOP;
    ri.cRecordsInsert=nspells;
    
    WinSendMsg(hwndcnr,
	       CM_INSERTRECORD,
	       MPFROMP(newrecords),
	       MPFROMP(&ri));

    if (!readonly) saved=false;
    return(true);
}

// create a subset, given a window to choose from and a selection dialog.
// returns true if a subset was found, else false.
boolean create_subset(bookwindow *mywin,HWND dlg) {
    bookwindow *nsw=NULL;
    spellrecord *sr;
    spell *s;
    char *tmpstr;
    magespell *ms;
    priestspell *ps;
    boolean matches,itemmatch;
    int i,j;

    // see if we're doing "and" or "or"
    boolean s_and;
    if (WinQueryButtonCheckstate(dlg,DLG_AND)==1) s_and=true;
    else s_and=false;

    // see if things are case sensitive
    boolean s_nocase=false;
    if (WinQueryButtonCheckstate(dlg,DLG_CASE)==0) s_nocase=true;

    // see if there's a restriction on the name.
    boolean s_name;
    char *str_name;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_NAME))==0) 
	s_name=false;
    else {
	s_name=true;
	str_name=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_NAME,i+1,(PSZ)str_name);
	if (s_nocase) upstr(str_name);
    }

    // check school
    boolean s_school;
    char *str_school;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_SCHOOL))==0) 
	s_school=false;
    else {
	s_school=true;
	str_school=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_SCHOOL,i+1,(PSZ)str_school);
	if (s_nocase) upstr(str_school);
    }

    // check sphere
    boolean s_sphere;
    char *str_sphere;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_SPHERE))==0) 
	s_sphere=false;
    else {
	s_sphere=true;
	str_sphere=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_SPHERE,i+1,(PSZ)str_sphere);
	if (s_nocase) upstr(str_sphere);
    }

    // check mage,priest,reversible
    boolean s_mage;
    boolean s_priest;
    boolean s_reversible;
    if (WinQueryButtonCheckstate(dlg,DLG_MAGE)==1) s_mage=true;
    else s_mage=false;
    if (WinQueryButtonCheckstate(dlg,DLG_PRIEST)==1) s_priest=true;
    else s_priest=false;
    if (WinQueryButtonCheckstate(dlg,DLG_REVERSIBLE)==1) s_reversible=true;
    else s_reversible=false;

    
    // check save
    boolean s_save;
    char *str_save;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_SAVE))==0) 
	s_save=false;
    else {
	s_save=true;
	str_save=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_SAVE,i+1,(PSZ)str_save);
	if (s_nocase) upstr(str_save);
    }

    // check components
    boolean s_components;
    boolean s_c_v=false;
    boolean s_c_s=false;
    boolean s_c_m=false;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_COMPONENTS))==0) 
	s_components=false;
    else {
	s_components=true;
	tmpstr=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_COMPONENTS,i+1,(PSZ)tmpstr);
	upstr(tmpstr);
	if (strchr(tmpstr,'V')!=0) s_c_v=true;
	if (strchr(tmpstr,'S')!=0) s_c_s=true;
	if (strchr(tmpstr,'M')!=0) s_c_m=true;
	delete tmpstr;
    }

    // see if there's a restriction on the level.
    boolean s_level;
    boolean s_level_gt=false;
    boolean s_level_lt=false;
    int int_level=0;
    if ((i=WinQueryDlgItemTextLength(dlg,DLG_LEVEL))==0) 
	s_level=false;
    else {
	s_level=true;
	tmpstr=new char[i+1];
	WinQueryDlgItemText(dlg,DLG_LEVEL,i+1,(PSZ)tmpstr);
	if (tmpstr[0]=='>') {
	    s_level_gt=true;
	    sscanf(tmpstr,">%d",&int_level);
	}
	else if (tmpstr[0]=='<') {
	    s_level_lt=true;
	    sscanf(tmpstr,"<%d",&int_level);
	}
	else sscanf(tmpstr,"%d",&int_level);
	delete tmpstr;
    }

    // see if there's a description search going
    boolean s_desc;
    int int_desc;
    int str_desc_len;
    boolean s_desc_and=false;
    PCHAR *str_desc;
    HWND dh=WinWindowFromID(dlg,DLG_DESCRIPTION);
    if (WinSendMsg(dh,
		   MLM_QUERYTEXTLENGTH,
		   0,0)==0)
	s_desc=false;
    else {
	int_desc=(int)WinSendMsg(dh,
				 MLM_QUERYLINECOUNT,
				 0,0);
	str_desc=new PCHAR[int_desc];
	IPT pos= 0;

	// see if we're and'ing or or'ing the description search.
	if (WinQueryButtonCheckstate(dlg,DLG_DES_AND)==1) s_desc_and=true;

	// set up xfer buffer
	WinSendMsg(dh,
		   MLM_SETIMPORTEXPORT,
		   (MPARAM)(&xfer_buffer),
		   (MPARAM)10240);
	WinSendMsg(dh,
		   MLM_FORMAT,
		   (MPARAM)MLFIE_NOTRANS,
		   0);
	for (i=0; i<int_desc; i++) {
	    WinSendMsg(dh,MLM_SETSEL,(MPARAM)pos,(MPARAM)pos);
	    j=(int)WinSendMsg(dh,
			      MLM_QUERYLINELENGTH,
			      (MPARAM)pos,
			      0);
	    str_desc[i]=new char[j+1];
	    str_desc_len=j;
	    WinSendMsg(dh,
		       MLM_EXPORT,
		       (MPARAM)&pos,
		       (MPARAM)&j);
	    strncpy(str_desc[i],(char *)xfer_buffer,str_desc_len);
	    str_desc[i][str_desc_len]=(char)0;

	    // get rid of \n at end of string.
	    if ((str_desc_len>1) && (i<int_desc-1))
		str_desc[i][str_desc_len-1]=(char)0;

	    if (s_nocase) upstr(str_desc[i]);
	}
    }
    
    // get first spell
    sr=(spellrecord *)
	WinSendMsg(mywin->hwndcnr,
		   CM_QUERYRECORD,
		   0,
		   MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER));
    while (sr!=NULL) {
	s=sr->s;
	ms=(magespell *)s;
	ps=(priestspell *)s;
	if (s_and) matches=true;
	else matches=false;

	// see if this spell matches selection.
	if (s_name) {
	    if (s_nocase) {
		tmpstr=strdup(s->name);
		upstr(tmpstr);
		itemmatch=(boolean)(strstr(tmpstr,str_name)!=0);
		delete tmpstr;
	    }
	    else itemmatch = (boolean)(strstr(s->name,str_name)!=0);

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_school) {
	    if ((s->type=='M') || (s->type=='P')) {
		if (s_nocase) {
		    tmpstr=strdup(ms->school);
		    upstr(tmpstr);
		    itemmatch=(boolean)(strstr(tmpstr,str_school)!=0);
		    delete tmpstr;
		}
		else itemmatch = (boolean)(strstr(ms->school,str_school)!=0);
	    }
	    else itemmatch=false;

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_sphere) {
	    if (s->type=='P') {
		if (s_nocase) {
		    tmpstr=strdup(ps->sphere);
		    upstr(tmpstr);
		    itemmatch=(boolean)(strstr(tmpstr,str_sphere)!=0);
		    delete tmpstr;
		}
		else itemmatch = (boolean)(strstr(ps->sphere,str_sphere)!=0);
	    }
	    else itemmatch=false;

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_level) {
	    if (s_level_gt) itemmatch = (boolean)(s->level > int_level);
	    else if (s_level_lt) itemmatch = (boolean)(s->level < int_level);
	    else itemmatch = (boolean)(s->level == int_level);

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_save) {
	    if ((s->type=='M') || (s->type=='P')) {
		if (s_nocase) {
		    tmpstr=strdup(ms->save);
		    upstr(tmpstr);
		    itemmatch=(boolean)(strstr(tmpstr,str_save)!=0);
		    delete tmpstr;
		}
		else itemmatch = (boolean)(strstr(ms->save,str_save)!=0);
	    }
	    else itemmatch=false;

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_mage) {
	    itemmatch=(boolean)(s->type=='M');

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_priest) {
	    itemmatch=(boolean)(s->type=='P');

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_reversible) {
	    if ((s->type=='M') || (s->type=='P')) 
		itemmatch=ms->reversible;
	    else itemmatch=false;

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	if (s_components) {
	    if ((s->type=='M') || (s->type=='P')) {
		itemmatch=(boolean)(s_c_v || s_c_m || s_c_s);
		if (s_c_v) itemmatch = 
		    (boolean)(itemmatch && strchr(ms->components,'V'));
		if (s_c_s) itemmatch = 
		    (boolean)(itemmatch && strchr(ms->components,'S'));
		if (s_c_m) itemmatch = 
		    (boolean)(itemmatch && strchr(ms->components,'M'));
	    }
	    else itemmatch=false;

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}
	// only search thru the descs if it matters... slow!
	if ((s_desc) &&
	    (((s_and) && (matches==true)) ||
	     ((s_and==false) && (matches==false)))) {
	    if (s_desc_and) itemmatch=true;
	    else itemmatch=false;

	    for (i=0; i<int_desc; i++) {
		if (strlen(str_desc[i])!=0) {
		    if (s_desc_and) itemmatch = 
			(boolean)(itemmatch && 
				  s->desc_search(str_desc[i],s_nocase));
		    else itemmatch = 
			(boolean)(itemmatch || 
				  s->desc_search(str_desc[i],s_nocase));
		}
	    }

	    if (s_and) matches = (boolean)(matches && itemmatch);
	    else matches = (boolean)(matches || itemmatch);
	}

	// if it still matches, add it in.
	if (matches) {
	    if (!nsw) nsw=new bookwindow("Selection Matches:");
	    nsw->add_spell(s);
	}

	// get next spell
	sr=(spellrecord *)
	    WinSendMsg(mywin->hwndcnr,
		       CM_QUERYRECORD,
		       (MPARAM)sr,
		       MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER));
    }

    // see if any spells were actually selected
    if (nsw==NULL) {
	WinMessageBox(HWND_DESKTOP,
		      HWND_DESKTOP,
		      (PSZ)"No spells in this book matched these selection criteria",
		      (PSZ)"Sorry!",
		      102,
		      MB_OK|MB_ICONEXCLAMATION);
	return(false);
    }
    
    // don't bug the user about closing the window
    nsw->saved=true;
    nsw->refresh();
    return(true);
}

// sort according to fields in sb integer array.
SHORT APIENTRY spell_order(PRECORDCORE prc1, PRECORDCORE prc2, PVOID sb) {
    spellrecord *psr1, *psr2;
    int *sortby = (int *)sb;
    int i;
    SHORT cmp=0;
    char *a, *b;

    psr1=(spellrecord *)prc1;
    psr2=(spellrecord *)prc2;
    priestspell *ps1 = (priestspell *)(psr1->s);
    priestspell *ps2 = (priestspell *)(psr2->s);

    for (i=0; i<5; i++) {
	/* sorting by:
	0 = "None",
	1 = "Caster Type",
	2 = "Name of Spell",
	3 = "Spell Level",
	4 = "School/Sphere",
	5 = "Components",
	6 = "Save"
	*/
	switch (sortby[i]) {
	case 1:
	    if ((ps1->type=='P') && (ps2->type=='M'))
		cmp = -1;
	    if ((ps1->type=='M') && (ps2->type=='P'))
		cmp = 1;
	    break;
	case 2:
	    cmp = strcmpi(ps1->name,ps2->name);
	    break;
	case 3:
	    if (ps1->level < ps2->level) cmp = -1;
	    if (ps1->level > ps2->level) cmp = 1;
	    break;
	case 4:
	    if (ps1->type=='P') a=ps1->sphere;
	    else a=ps1->school;
	    if (ps2->type=='P') b=ps2->sphere;
	    else b=ps2->school;
	    cmp = strcmpi(a,b);
	    break;
	case 5:
	    cmp = strcmpi(ps1->components,ps2->components);
	    break;
	case 6:
	    cmp = strcmpi(ps1->save,ps2->save);
	    break;
	}
	if (cmp) return(cmp);
    }
    return(0);
}

// sort spellbook
boolean bookwindow::sort_book(ULONG sortorder) {
    spelllist *sl1, *sl2;
    int sortby[5];
    int j;

    titleprintf(hwndframe,"%s:  Sorting Book...",sb->name);

    // figure out what the ULONG code means:
    for (j=0; j<5; j++) {
	sortby[j] = sortorder % 7;
	sortorder /= 7;
    }

    WinSendMsg(hwndcnr,
	       CM_SORTRECORD,
	       (MPARAM)(spell_order),
	       (MPARAM)sortby);

    // sort sb also, according to result of container sort
    spellrecord *i;
    i=(spellrecord *)
	WinSendMsg(hwndcnr,
		   CM_QUERYRECORD,
		   0,
		   MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER));

    if (i==NULL) return(false);

    sl1=i->spl;
    sb->first=sl1;
    sl1->prev=NULL;  
    while (i!=NULL) {
	i=(spellrecord *)
	    WinSendMsg(hwndcnr,
		       CM_QUERYRECORD,
		       (MPARAM)i,
		       MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER));
	if (i!=NULL) {
	    sl2=i->spl;
	    sl2->prev=sl1;
	    sl1->next=sl2;
	    sl1=sl2;
	}
    }
    sl1->next=NULL;
    sb->last=sl1;

    titleprintf(hwndframe,"%s",sb->name);
    saved=false;
    return(true);    
}

// object window procedure
MRESULT EXPENTRY object_window_func(HWND hwnd, ULONG msg, 
				    MPARAM param1, MPARAM param2) {
    bookwindow *mywin;
    spellbook *newsb;
    long masterdate,quickdate;
    int rc;
    ULONG count_sem;

    switch(msg) {
    case WM_CREATE:
	// save book handle in first window
	first->hwndobject=hwnd;

	// save pointer to my instance in window word
	WinSetWindowPtr(hwnd,
			0,
			first);

	// tell main window I'm ready.
	DosPostEventSem(sem_object_started);

	return (MRESULT)0;
	break;

    case WM_USER_LOAD_MASTER:
	// find most recent master list, load it in
	masterdate = query_last_write(master_name);
	quickdate = query_last_write(quick_master_name);
	if (masterdate > quickdate) {
	    // load in the master list from "slow" file, then quicksave copy
	    masterlist=get_master_list(master_name);  
	    masterlist->name=strdup("Master Spell List");
	    if (masterlist)
		masterlist->quicksave(quick_master_name);
	}
	else { // load in quick copy of list
	    masterlist=new spellbook;    
	    if (masterlist->quickload(quick_master_name)==false) {
		delete masterlist;
		masterlist = NULL;
	    }
	    else if (masterlist->name==NULL)
		masterlist->name=strdup("Master Spell List");
	}
	return (MRESULT)0;
	break;

    case WM_USER_SHOW_MASTER:
	mywin=(bookwindow *)WinQueryWindowPtr(hwnd,0);

	DosRequestMutexSem(sem_master_loading,SEM_INDEFINITE_WAIT);
	if (!masterlist) {
	    // wait for master window to be loaded
	    WinSendMsg(mywin->hwndobject, WM_USER_LOAD_MASTER, 0,0);
	}
	DosReleaseMutexSem(sem_master_loading);
	if (!masterlist) 
	    titleprintf(mywin->hwndframe,"Can't Load Master List!");
	else {
	    titleprintf(mywin->hwndframe,
			"%s:  Loading Icons...",masterlist->name);
	    mywin->set_spellbook(masterlist);
	    titleprintf(mywin->hwndframe,"%s",masterlist->name);
	}

	// reactivate the main window
	WinPostMsg( mywin->hwnd,WM_USER_ACK,(MPARAM)msg,0);

	break;

    case WM_USER_SAVE:
	// param1 should contain a value for just titles, 0 for entire book.
	mywin=(bookwindow *)WinQueryWindowPtr(hwnd,0);
	titleprintf(mywin->hwndframe,"Saving to %s",mywin->filename);

	if (param1) rc = mywin->sb->print_titles(mywin->filename);
	else rc = mywin->sb->print_book(mywin->filename);

	if (rc==0) {
	    mywin->saved=true;
	    titleprintf(mywin->hwndframe,"%s",mywin->sb->name);
	}
	else
	    titleprintf(mywin->hwndframe,"Error saving to %s",mywin->filename);

	WinPostMsg( mywin->hwnd,WM_USER_ACK,(MPARAM)msg,0);
	return (MRESULT)0;
	break;
	
    case WM_USER_LOAD:
	mywin=(bookwindow *)WinQueryWindowPtr(hwnd,0);
	titleprintf(mywin->hwndframe,"Loading %s...",mywin->filename);

	newsb = new spellbook;
	DosRequestMutexSem(sem_master_loading,SEM_INDEFINITE_WAIT);
	rc = newsb->read(mywin->filename, masterlist);
//	titleprintf(mywin->hwndframe,"rc = %d",rc);
	if ((rc) && (!masterlist)) {
	    // be sure master list is loaded.
	    WinSendMsg(mywin->hwndobject, WM_USER_LOAD_MASTER, 0,0);
	    DosReleaseMutexSem(sem_master_loading);
//	    titleprintf(mywin->hwndframe,"read masterlist");
	    if (masterlist)
		rc = newsb->read_titles(mywin->filename,masterlist);
	}
	else 
	    DosReleaseMutexSem(sem_master_loading);

//	titleprintf(mywin->hwndframe,"DONE");

	if (rc==-1) 
	    titleprintf(mywin->hwndframe,"Error loading %s",mywin->filename);
	else {
	    mywin->set_spellbook(newsb);
	    titleprintf(mywin->hwndframe,"%s",mywin->sb->name);
	}
	if (rc>0) {
	    sprintf((char *)xfer_buffer,
		    "%s:  %d spells not found in master list",
		    mywin->sb->name, rc);
	    WinMessageBox(HWND_DESKTOP,
			  HWND_DESKTOP,
			  (PSZ)xfer_buffer,
			  (PSZ)"Warning!",
			  102,
			  MB_OK|MB_ICONEXCLAMATION);
	}

	delete newsb;
	WinPostMsg( mywin->hwnd,WM_USER_ACK,(MPARAM)msg,0);
	return (MRESULT)0;
	break;

    case WM_USER_SORT:
	mywin=(bookwindow *)WinQueryWindowPtr(hwnd,0);
	if (!mywin->sort_book((ULONG)param1))
	    titleprintf(mywin->hwndframe,"Error sorting %s",mywin->sb->name);
	WinPostMsg( mywin->hwnd,WM_USER_ACK,(MPARAM)msg,0);
	return (MRESULT)0;
	break;

    case WM_USER_CREATE_SUBSET:
	mywin=(bookwindow *)WinQueryWindowPtr(hwnd,0);
	titleprintf(mywin->hwndframe,"Finding subset...");
	if (create_subset(mywin,(HWND)param1)) 
	    WinPostMsg((HWND)param1,
		       WM_USER_ACK,
		       (MPARAM)1,0);
	else 
	    WinPostMsg((HWND)param1,
		       WM_USER_ACK,
		       0,0);
	titleprintf(mywin->hwndframe,"%s",mywin->sb->name);
	WinPostMsg( mywin->hwnd,WM_USER_ACK,(MPARAM)msg,0);
	return (MRESULT)0;
	break;
    }
    return WinDefWindowProc(hwnd, msg, param1, param2);
}


// entry point for 2nd threads started by spellbook windows
void _Optlink threadmain(void *f) {
    HAB hab;
    HMQ hand_mq;  // message queue 
    QMSG q_mess;  // message queue 

    hab=WinInitialize(0);  // get anchor block 
    hand_mq = WinCreateMsgQueue(hab, 0); // start queue 

    first=(bookwindow *)f;

    if (!WinRegisterClass(
			  hab,
			  (PSZ) spbobjclass,
			  (PFNWP) object_window_func,
			  0,
			  sizeof(bookwindow *)))
	exit(1);

    WinCreateWindow(HWND_OBJECT,
		    spbobjclass,
		    "",
		    0,0,0,0,0,
		    HWND_OBJECT,
		    HWND_BOTTOM,
		    0,0,0);

    // message loop 
    while(WinGetMsg(hab, &q_mess, 0L,0,0))
	WinDispatchMsg(hab, &q_mess);

    WinDestroyMsgQueue(hand_mq);
    WinTerminate(hab);
}
