
#include <iostream.h> // DEBUG

#include "random.h"

#include "CBuildCommand.h"
#include "phrase.h"
#include "phrasnfo.h"
#include "phradptr.h"
#include "iterator.h"
#include "rhytmblk.h"

#include "jam/JPhraseController.h"
#include "jam/JPhrase.h"
#include "jam/JNoteGesture.h"
#include "jam/JContext.h"
#include "jam/JFocus.h"
#include "jam/JMapper.h"
#include "jam/JVoice.h"
#include "jam/JVoiceManager.h"
#include "jam/JDeviceManager.h"
#include "jam/JConductor.h"

#include "jam/JComposition.h"

#include <fstream.h>
#include <ctype.h>
#include <string.h>
#include <iomanip.h>


#define N_CMD  22
#define N_CHAR 20



void mutate(phrase_adapter_c *adapter)
{
  //  static char word_t[N_CMD][N_CHAR];
  //  initialise_values(word_t, variable_values_i);

  int    variable_values_i[35];

  ifstream ini_s;
  ini_s.open("composer.pjl");

  if(ini_s.fail()){
	 cout << "Error: Composer.pjl could not be found/opened...\n\n";
	 cout << "Composer not run.\n\n";
	 exit(1);
  }

  char line[132];  	

  ini_s.getline(line,132);
  long seedVal = atoi(line);
  
  srand(seedVal);
  
  for (int i=0; i< 33 ; i++) {
    ini_s.getline(line,132);
    variable_values_i[i] = atoi(line);
    cout << variable_values_i[i] << endl;
  }


  //  char d;

  adapter->set_variables(variable_values_i);

  adapter->process_phrase();

}


void 
cPhraseToPhrase(phrase_adapter_c *adapter_p, 
		JPhraseController *controller)
{
  note_info_c *note_info_p;
  phrase_info_c *phrase_info_p;
  int end_i;
  char d;

  note_info_p = new note_info_c;
  if(note_info_p == NULL){
    cout << "FATAL ERROR: Cannot allocate memory..." << endl;
    cin.get(d);
  }
  phrase_info_p = new phrase_info_c;
  if(phrase_info_p == NULL){
    cout << "FATAL ERROR: Cannot allocate memory..." << endl;
    cin.get(d);
  }

  // Retreive new phrase //

  adapter_p->get_info(1, phrase_info_p);

  /*
    cout << "Tempo " << phrase_info_p->tempo_int << endl;
    cout << "Beats in Bar" << phrase_info_p->beats_in_bar_int << endl;
    cout << "Beat Type" << phrase_info_p->beat_type_int << endl << endl;
    */

  adapter_p->setup_read();

  do{
    end_i = adapter_p->get_note(1, note_info_p);

    /*
      cout << "Beat " << note_info_p->beat_int << endl;
      cout << "Num " << note_info_p->numerator_int << endl;
      cout << "Denom " << note_info_p->denominator_int << endl;
      cout << "Note " << note_info_p->note_int << endl;
      cout << "Length " << note_info_p->length_dbl << endl;
      cout << "Velocity " << note_info_p->velocity_int << endl;
      cin.get(d);
      */


      int beat_i=note_info_p->beat_int -1 ;
      int numerator_i=note_info_p->numerator_int;
      int denominator_i=note_info_p->denominator_int;
      int note_i=note_info_p->note_int;
      double length_d = note_info_p->length_dbl;
      int velocity_i = note_info_p->velocity_int;

    JBeat beat(beat_i,numerator_i,denominator_i);

    JGesture *note = new JNoteGesture(beat,length_d,note_i,velocity_i);

    controller->insertGesture(note);



  }while(end_i == 0);

  delete note_info_p;
  delete phrase_info_p;
}


static phrase_adapter_c * phraseToCPhrase(const JPhrase *phrase) 
{

  phrase_adapter_c *adapter=0;  

  JGestureListIterator iter(phrase->gestureList());

  JGesture *gesture;

  int denominator_i = 16 ;


  while( (gesture = iter.next()) != 0) {
    JNoteGesture * note = gesture->noteGesture();
    if (note != 0) {
      double beat=note->start().rep() + 1.0;
      int beat_i= (int)(beat);
      double fract = beat-beat_i;

      int numerator_i   = (int)(fract*denominator_i + 0.5);
      double length_d   = note->duration().rep();
      int velocity_i    = note->velocity();
      int note_i        = note->pitch();

      cout << numerator_i << "/" << denominator_i << endl ;

      if (adapter == 0) {
        adapter = new phrase_adapter_c(120,4,4,beat_i ,numerator_i,denominator_i,
	      	       note_i, length_d,velocity_i);
      } else {
	adapter->add_note(beat_i, numerator_i,denominator_i,
			  note_i, length_d ,velocity_i);
      }
    }
  }

  return adapter;
}



CBuildCommand::CBuildCommand(JContext *context):_context(context){;}


void
CBuildCommand::execute()
{
  JPhrase * inputPhrase = _context->focus()->phrase();
  
  if (inputPhrase == 0 ) return;
  
  phrase_adapter_c * adapter = phraseToCPhrase(inputPhrase);

  JVoice * voice = JVoiceManager::the()->newVoice();

  _context->conductor()->attach(voice);

  JTrack *track = _context->composition()->newTrack(voice);

  _context->focus()->setTrack(track);

  JPhrase *newPhrase = new JPhrase(track->player(),track,_context->focus()->part());

  mutate(adapter);

  cPhraseToPhrase(adapter,newPhrase->controller());

  _context->focus()->setPhrase(newPhrase);
  
  newPhrase->update();

}



