#ifndef _phrase_adapter_c_H
#define _phrase_adapter_c_H

// This file is an object called phrase_adapter //
// 17 march 1998 Julian Sweeting //

class phrase_info_c;
class note_info_c;
class flow_block_c;
class beat_block_c;
class random_control_c;
class rhythm_correlate_c;
class scale_analyse_c;
class flow_analyse_c;
class phrase_c;

class phrase_adapter_c{
  public:
	 phrase_adapter_c();
	 phrase_adapter_c(double tempo_d, int beats_in_bar_i, int beat_type_i,
							int beat_i, int numerator_i, int denominator_i,
							int note_i, double length_d, int velocity_i);
	 void add_note(int beat_i, int numerator_i, int denominator_i,
						int note_i, double length_d, int velocity_i);
	 void remove_all();
	 void process_phrase();
	 void setup_read();
	 void get_info(int new_i, phrase_info_c *phrase_info_p);
	 int get_note(int new_i, note_info_c *note_info_p);
	 void set_variables(int *values_i);
  private:
	 void create_sub_systems();
	 void select_location(int location_type);
	 void fit_lengths(int *fraction_array_p, int left_block_i,
							int current_block_i);
	 void call_function(int function_i, int num_i);

	 void change_note(int own_location_i);
	 void change_corr(int corr_change_type_i);
	 void eliminate(int eliminate_type_i);
	 void find_notes(int *upper_notes_i, int *lower_notes_i,
	                 int *avoid_notes_i);

    // Variables loaded from composer.ini //
	 int allow_scale_morph_int;
	 int morph_limit_int;
	 int fix_start_note_location_int;
	 int fix_start_note_pitch_int;
	 int adjust_scale_variation_int;
	 int svlow_int;
	 int svmidl_int;
	 int svmidh_int;
	 int svhigh_int;
	 int allow_phrase_growth_int;
	 int growth_fraction_array_ptr[3];
	 int no_process_loops_int;
	 int note_changes_in_loop_int;
	 int corr_shuffles_in_loop_int;
	 int corr_increases_in_loop_int;
	 int corr_decreases_in_loop_int;
	 int intro_notes_in_loop_int;
	 int intro_corr_notes_in_loop_int;
	 int elim_notes_in_loop_int;
	 int elim_block_in_loop_int;
    int elim_corr_notes_in_loop_int;
	 int elim_corr_block_in_loop_int;
	 int rclow_int;
	 int rcmidl_int;  // rc - Rhythm correlation, select controls //
	 int rcmidh_int;
	 int rchigh_int;
	 int smaller_fraction_value_int;
	 int fslow_int;
	 int fsmidl_int;
	 int fsmidh_int;
	 int fshigh_int;

	 int morph_count_int;
	 int fraction_array_ptr[3];
	 int *fraction1_array_ptr;
	 int *fraction2_array_ptr;
	 flow_block_c *flow_block_ptr;
	 random_control_c *randomc_ptr;
	 rhythm_correlate_c *corr_ptr;
	 scale_analyse_c *scale_ptr;
	 flow_analyse_c *flow_ptr;
	 phrase_c *phrase_ptr;
	 phrase_c *original_phrase_ptr;
};


#endif







