#include <iostream.h>
#include <stdarg.h>

#include "japp/JApplication.h"
#include "jam/JDeviceManager.h"  //  /dev/sequencer interface
#include "jam/JComposition.h"
#include "jam/JVoice.h"
#include "jam/JMidiIn.h"

#include "jam/JPhrase.h"
#include "jam/JFocus.h"
#include "jam/JDevice.h"
#include "jam/JConductor.h"
#include "jam/JMidiFileReader.h"
#include "jam/JTrack.h"
#include "jam/JVoiceManager.h"
#include "jam/JNoteGesture.h"
#include "jam/JSweepGesture.h"
#include "jam/JEffectEventGesture.h"
#include "rep/JMidiDefines.h"

#ifdef J_HAVE_AWE
#include <linux/awe_voice.h>
#endif

//void dummyPox(){JRepeatPhrase pox(0);} // cures strange symbol size error 


int main()
{

  // Set up the devices

  JDeviceManager *manager=JDeviceManager::the();

  JApplication japp;
    
  // Create a blank song.
  JComposition composition("Song");

  int nDev = manager->nOutDevice();
  int i;

  cout << "\n Supported Devices" << endl;

  for(i=0; i < nDev ; i++ ) {
    cout << "[" << i << "] " <<  manager->outDevice(i)->name() << endl;
  }

  do {
    cout << " Enter the device you want to torture :";
    cin  >> i;
  } while (i <0 && i >= nDev);

  JVoiceManager::the()->setDefaultDevice(i);


  JVoice * voice        = JVoiceManager::the()->newVoice();
  JTrack * track        = composition.newTrack(voice);
  JPhrase *phrase       = track->newPhrase();
  

  JBeat start(1);
  JBeat b(1);
  JBeat end(60);
  JDuration tick(0,1,4);


  while(b < end) {
    JGesture * g = new JNoteGesture(b,tick,64+i%4,120);
    phrase->appendGesture(g); 
    b += tick + tick ;
  }

  JGesture * 
    g = new JSweepGesture(start,end-start,
			  JMidiOutEvent(JMidiOutType::CNTRL_EFFECT,CTL_PAN),
			  0,127);

  phrase->insertGesture(g); 
  
  g = new JEffectEventGesture(JBeat(1),
			      JMidiOutEvent(JMidiOutType::AUX_EFFECT,
					    AWE_FX_FILTERQ,
					    64));

  phrase->insertGesture(g); 
  
  g = new JSweepGesture(start,end-start,
			JMidiOutEvent(JMidiOutType::AUX_EFFECT,AWE_FX_CUTOFF),
			127,4);
  
  phrase->insertGesture(g); 

//   g = new JSweepGesture(JBeat(11),JDuration(20),
// 			JMidiOutEvent(JMidiOutType::AUX_EFFECT,AWE_FX_CUTOFF),
// 			4,127);
  

//   phrase->insertGesture(g); 

//   g = new JSweepGesture(JBeat(1),b-JBeat(1),
// 			JMidiOutEvent(JMidiOutType::AUX_EFFECT,AWE_FX_FILTERQ),
// 			0,127);

//   phrase->insertGesture(g); 


  JConductor conductor(&composition);
  conductor.handle(JConductorCommand::START);


  cout << " ^C to quit " << endl;

  while(1);


  
}



