#ifndef _JITScheduler_H
#define _JITScheduler_H


//#define STATISTICS

// Singleton class
// Uses a SIGALRM to interupt at specifiy moment and call the installed
// callback

// If you want to get clever do it in the callback.

#include "assert.h"
#include "JSysTime.h"
#include "jam/JScheduler.h"
#include "jam/JTimer.h"

///
class JTimerClient;

class JITScheduler:public JTimer,public JScheduler
{
  
public:

  JITScheduler(){;} 
  ~JITScheduler();

  // Scheduler
  void  launch(JTime slice);
  void  setSliceClient(JTimerClient *client) {_sliceClient=client;}
  void  setAlarmClient(JTimerClient *client) {_alarmClient=client;}
  void  setAlarmAt(const JBeat &when);
  void  setTempo(double bpm);
  double tempo() const { return _bpm;}

  // JTimer
  void  setNow(const JBeat &now); 
  JBeat beatNow() const;
  void  stop();
  void  start();
  bool  isStoped() const { return _stoped; }


protected:

  static void  handler(int id);

  static JTimerClient  *  _alarmClient;
  static JTimerClient  *  _sliceClient;
  static JSysInterval     _sysSlice;
  static JSysTime         _tLast;
  static JTime            _tSlice;
  static double           _beatsPerSlice;
  static double           _bpm;
  static double           _beatNow;
  static bool             _stoped;
  static double           _alarmBeat; 

#ifdef STATISTICS
public:
  static void statistics();
#define MAX_TICKS        500
  static unsigned long    _misses[MAX_TICKS];
#endif
};



#endif






