void
JTrackNotator::repair(const JEventPhrase *phrase,
		      JBeat from,
		      JBeat till,
		      bool wipe)
{

  bool hiPhrase = (phrase == _focus->phrase());
  const JEvent * focusEvent;
  JStyle   phraseStyle=NORMAL;
  JStyle   style=NORMAL;

  if (hiPhrase) {
    focusEvent = ((JEventPhrase *)phrase)->controller()->focus();
  } else {
    phraseStyle=DULL;
  }
  
  // Next call may change from and till.

  _scorePainter->setName(_track->name());

  if (wipe) {
    _scorePainter->clear(from,till);
    repairBars(from,till,false);
  }

  const JEventPhrase *lPhrase=phrase->eventPhrase();

  if (lPhrase == 0) return;

  JEventPhraseIterator iter(lPhrase);

  const JEvent *event;

  JBeat offBeat;
  JBeat lastOff;
  int on=0;
  int quantize = 16;
  bool first   = true;
  while( (event=iter.nextEvent()) != 0 ) {

    // wait till we are in the zone
    //    if (event->beat() < from )  continue;

    // Bomb out when we have had enough
    if (event->beat() > till) return;

    assert(on >= 0);

    const JEffectNode *node = event->seekEffect(NOTE_EFFECT);

    if (node == 0 ) continue;
    int pitch = node->index();

    if (node->value() == 0 ) {
      --on;
      lastOff=event->beat();
      lastOff.quantize(quantize);
      continue;
    }
    
    on++;
    JBeat onBeat  = event->beat();
    onBeat.quantize(quantize);

    if (event->beat() < from )  continue;

    if ( (!first)  && (on == 1) ) { 
      if (lastOff < onBeat) {
#ifdef J_DEBUG
	cout << "TrackNotator:rest " << offBeat << " -- " <<
	  onBeat << endl;
#endif

	_scorePainter->drawRest(lastOff,
				onBeat - lastOff,
				pitch,phraseStyle);
      }
    }

    first=false;

      // count the note on events
    const JEvent *offEvent = node->right()->event();
    offBeat = offEvent->beat();
    offBeat.quantize(quantize);

    assert(offEvent != 0);
    
    JDuration duration     = offBeat - onBeat;
    
	
    if (offBeat >= from)
      if (onBeat <= till) {
#ifdef J_DEBUG
	cout << "TrackNotator:note " << onBeat << " -- " <<
	  offBeat << endl;
#endif

	if (event == focusEvent) 
	  style=HILIGHT;
	else
	  style=phraseStyle;

	_scorePainter->drawNote(onBeat,
				duration,
				pitch,
				style);
	
      }
  } 

  // HACK 
  const JBeat &cBeat=_focus->cursor()->beat();
  
  if (cBeat > offBeat) {
    int pitch=_focus->cursor()->pitch();
    _scorePainter->drawRest(offBeat,
			    cBeat-offBeat,
			    pitch);
  }
  
}

