#include <qpopmenu.h>
#include "QJCompositionView.h"
#include "jam/JComposition.h"
#include "jam/JVoiceManager.h"
#include "QJTrackItem.h"
#include "jam/JTrackList.h"
#include "jam/JContext.h"
#include "assert.h"
#include "jam/JFocus.h"

QJCompositionView::QJCompositionView(QWidget *parent,JContext *context)
  :QListView(parent),
   _comp(0),_context(context),_selectedTrack(0),_trackItem(0),_colSelected(-1),
   _editPress(false)
{
  _popup =  new QPopupMenu(0);

  _popup->insertItem("insert track",this,SLOT(newTrack())); 
  _popup->insertItem("clone",this,SLOT(cloneTrack())); 
  _popup->insertItem("delete",this,SLOT(deleteTrack())); 

  setCaption( "Track Browser" );

  addColumn( "Track" );
  setColumnAlignment(0,AlignRight);
  addColumn( "Mute" );
  setColumnAlignment(1,AlignCenter);
  addColumn( "Device" );
  addColumn( "Channel" );
  addColumn( "Program" );
  addColumn( "Bank" );

  connect(this,SIGNAL(selectionChanged(QListViewItem *)),
 	  SLOT(selectionChange(QListViewItem *)));

  connect(this,
	  SIGNAL(rightButtonPressed(QListViewItem *,const QPoint &,int)),
 	  SLOT(rightButtonPressedSlot(QListViewItem *, const QPoint &, int )));

  //  setAllColumnsShowFocus(true);
  setFocusPolicy (StrongFocus); 
  setTreeStepSize( 20 );

  rebuild();
}

void
QJCompositionView::rebuild()
{
  //destroy

  //  debug(" COMPVIEW rebuild ");

  QListViewItem *item;
  while( (item = firstChild()) != 0 ) {
    delete item;
  }

  // rebuild
  _comp=_context->composition();
  assert(_comp != 0);
  JTrackListIterator tracks(_comp->trackList());
  JTrack *track;
  while( (track=tracks.next()) != 0 ){
    (new QJTrackItem(this,track,_context));
  }
  _selectedTrack = 0;
}


void  
QJCompositionView::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == MidButton) {
    _popup->popup(QCursor::pos());
  } else {
    QListView::mousePressEvent(e);
  }
}

void  
QJCompositionView::mouseReleaseEvent(QMouseEvent *)
{
  _editPress = false;
}


void 
QJCompositionView::keyPressEvent(QKeyEvent *e)
{

  //  debug(" key press ");

  int jmp=0;

  if (_colSelected > 0) {
    if ( e->ascii() == '+') jmp = 1;
    if ( e->ascii() == '-') jmp = -1;
    if ( e->ascii() == ']' ) jmp = 10;
    if ( e->ascii() == '[') jmp = -10;
    if (jmp != 0 ) {
      if (_trackItem != 0) {
	_trackItem->cycleSelectedColumn(jmp);
	repaintItem(_trackItem);
	return;
      }
    }
  }
  e->ignore();
}

void 
QJCompositionView::mouseMoveEvent(QMouseEvent *e)
{

  //  debug(" move move ");

  int jmp;

  if (!_editPress) return;

  if (_colSelected > 0) {
    if (e->pos().y() > _anchor.y()) jmp=1;
    else jmp=-1;
    if (_trackItem != 0) {
	_trackItem->cycleSelectedColumn(jmp);
	repaintItem(_trackItem);
    }
  }
  

}


void
QJCompositionView::rightButtonPressedSlot(QListViewItem *it,
					  const QPoint &p,int c)
{

  if (it == 0) return ;

  if (_trackItem != 0) {
    _trackItem->selectColumn(-1);
    _trackItem->repaint();
  }

  _trackItem = (QJTrackItem *)it;
  _colSelected = c;
  _trackItem->selectColumn(c);
  _anchor = p;
  _trackItem->cycleSelectedColumn(1);

  it->repaint();
  _editPress = true;
  
  setFocus();

}

void 
QJCompositionView::setSelected(QListViewItem *it,bool flag)
{
  //  debug( " set slected called ");

  QListView::setSelected(it,flag);
  
}

QJCompositionView::~QJCompositionView()
{
  //  delete _popup;
}

void 
QJCompositionView::selectionChange(QListViewItem *it)
{
  //  debug("selection change");
  
  if (it == 0 ) {
    _selectedTrack = 0;
  } else {
    _selectedTrack = ((QJTrackItem *)it)->track();
  }
 
 _context->focus()->setTrack(_selectedTrack);

}

void QJCompositionView::newTrack()
{
  JVoice *voice = JVoiceManager::the()->newVoice();
  JTrack *track = _comp->newTrack(voice);
  (new QJTrackItem(this,track,_context));
}

void QJCompositionView::deleteTrack()
{
  if (_selectedTrack == 0 ) return;

  if (_trackItem != 0 ) {
    if (_trackItem->track() == _selectedTrack) {
      _trackItem = 0 ;
      _colSelected = -1;
    }
  }

  delete _selectedTrack;
  _context->focus()->setTrack(0);
  if (currentItem() != 0)  delete currentItem();
  _selectedTrack = 0;
}

void QJCompositionView::cloneTrack()
{
  if (_selectedTrack == 0 ) return;

  JTrack *track = _selectedTrack->clone();
  _comp->trackList()->add(track);
  (new QJTrackItem(this,track,_context));
}











