#ifndef _QJDraw_H
#define _QJDraw_H

class QPainter;
class QRect;

/**
 * QJDraw is the virtual base class for all drawable objects.
 * it provides a uniform interface covering objects that are drawn, loaded
 * as XBitmap files and those compound objects that are made up from one or
 * more drawable objects in the form of a list.
 */
class QJDraw
{
public:

  /** Draw the object on to the target device.
   * This function takes the co-ordinates of the top left hand corner of the 
   * area on the target device to which the object is to be copied  and the 
   * painter to use for the copy as arguments */

  ///Virtual destructor.
  virtual ~QJDraw(){}

  virtual void draw(int,int,QPainter *) const=0;
  ///Return the bounding box of the drawable object.

  virtual const QRect* bBox() const=0;
  ///Return the left co-ordinate of the object.
  virtual int x() const=0;
  ///Return the top co-ordinate of the object.
  virtual int y() const=0;
  ///Return the height of the object.
  virtual int height() const=0;
  ///Return the width of the object.
  virtual int width() const=0;
};

#endif  // _QJDraw_H

