#include <qfiledlg.h>
#include <fstream.h>

#include "QJReadCommand.h"

#include "jam/JContext.h"
#include "command/JConductorCommand.h"
#include "jam/JComposition.h"
#include "jam/JConductor.h"
#include "jam/JFocus.h"
#include "rep/JReader.h"


QJReadCommand::QJReadCommand(JContext *context):_context(context),
    _readDialog(new QFileDialog(".","*.can",0,"ReadFileDialog",TRUE))
{


}

QJReadCommand::~QJReadCommand()
{
//  delete _readDialog;

}


void
QJReadCommand::execute()
{

  _readDialog->exec();
  
  QString fname=_readDialog->selectedFile();


  ifstream ini_s;
  ini_s.open(fname.data());

  if(ini_s.fail()){
    cout << "Error: " << fname << " not found/opened...\n\n";
    cout << "Composer not run.\n\n";
    return;
  }

  debug(" selected file is %s ",fname.data());

  if (fname.isNull()) return;


  ifstream in(fname);

  if (in.fail()) {
    debug(" Could not open file ");
    in.close();
    return;
  }

  _context->conductor()->handle(JConductorCommand::STOP);

  JComposition *comp = _context->composition();

  comp->trackList()->clear(TRUE);
  
  JReader reader(in);


  comp->read(reader);

  _context->focus()->setTrack(comp->trackList()->first());

  emit newComposition();
}

