#include "assert.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <fcntl.h>

extern "C" {
#include <linux/soundcard.h>
#include <linux/awe_voice.h>
#include <awe/util.h>
#include <awe/aweseq.h>
#include <awe/awebank.h>
#include <awe/sffile.h>
}

#include "dirview.h"
#include "QJSBKItem.h"
#include "QJSBKPatchItem.h"

#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>


QJSBKItem::QJSBKItem( Directory * parent, const char * filename )
    : QListViewItem( parent ),f(filename) ,_sf(0)
{
    readable = TRUE;
}

QJSBKItem::QJSBKItem( QListView * parent )
    : QListViewItem( parent ), f(".") ,_sf(0)
{
    readable = TRUE;
}


QJSBKItem::~QJSBKItem()
{
  if (_sf != 0) free_soundfont(_sf);
  delete _sf;
}

void QJSBKItem::setOpen( bool o )
{
  
  if ( o && (childCount() == 0 ) ) {
    assert(_sf == 0);
    
    FILE *fp;		
    int i;	
    
    _sf = new SFInfo;
    
    /*fprintf(stderr, "opening %s..\n", argv[1]);*/
    if ((fp = fopen(f.name(), "r")) == NULL) {
      fprintf(stderr, "can't open soundfont file %s \n", f.name());
      _sf = 0;
      return;
    }
    if (load_soundfont(_sf, fp, TRUE)) {
      fprintf(stderr, "fail to read soundfont file");
      fclose(fp);
    }
    fclose(fp);
    
    for (i = 0; i < _sf->npresets-1; i++) {
      char *p;
      /* convert illegal characters */
      for (p = _sf->preset[i].hdr.name; *p; p++) {
	if (!isprint(*p) || *p == '{' || *p == '}')
	  *p = ' ';
	else if (*p == '[')
	  *p = '(';
	else if (*p == ']')
	  *p = ')';
      }
      new QJSBKPatchItem(this,&_sf->preset[i]);
    }
    
  }
  QListViewItem::setOpen( o );

}

void QJSBKItem::setup()
{
    setExpandable( TRUE );
    QListViewItem::setup();
}


QString QJSBKItem::fullName()
{
    return f.name();
}


const char * QJSBKItem::text( int column ) const
{
  static QString s;
  if (column == 0) {
    s=QFileInfo(f.name()).fileName();
    return s;
  }
  return 0;
}

void QJSBKItem::activate()
{

  int rc;
  
  if (ioctl(seqfd, SNDCTL_SEQ_RESETSAMPLES, &awe_dev) == -1) {
    perror("Sample reset");
    return;
  }

  rc = awe_load_bank((char *)f.name(), 0, false);
  
  if (rc == AWE_RET_OK) {
    int mem_avail = awe_dev;
    ioctl(seqfd, SNDCTL_SYNTH_MEMAVL, &mem_avail);
    printf("DRAM memory left = %d kB\n", mem_avail/1024);
  }
  
  if (rc == AWE_RET_NOMEM) {
    fprintf(stderr, "sfxload: no memory left\n");
    return;
  } else if (rc == AWE_RET_NOT_FOUND) {
    fprintf(stderr, "sfxload: can't find font file %s\n", f.name());
    return;
  }

}
  
  


