#include <qslider.h>
#include <qlcdnum.h>
#include <qlabel.h>
#include <qpushbt.h>

#include "QJSlider.h"
#include "jam/JEffect.h"
#include "jam/JMidiOut.h"

QJSlider::QJSlider(JEffect *effect,
		   JMidiOut *midiOut,
		   QWidget* parent, 
		   const char* name, WFlags f):
  QWidget(parent,name,f),
  _effect(effect),
  _midiOut(midiOut)

{

  _slider = new QSlider(effect->minValue(),
			effect->maxValue(),
			1,
			effect->value(),
			QSlider::Horizontal,
			this,effect->name());

  _on=FALSE;

  _slider->setEnabled(FALSE);

  _slider->setValue(0);

  _on=TRUE;

  _lcd = new QLCDNumber(6,this,"lcd");
  _lcd->setSegmentStyle(QLCDNumber::Flat);
  //  _lcd->setForegroundColor(QColor(255,0,0));
  _lcd->setFrameStyle(QFrame::NoFrame);

  _label = new QPushButton(effect->name(),this);

  //  _lcd->setBackgroundColor(QColor(0,0,0));
  
  _label->setToggleButton(TRUE);

  connect( _label, SIGNAL(toggled(bool)), SLOT(selectEffect(bool)) );

  connect( _slider, SIGNAL(valueChanged(int)), _lcd, SLOT(display(int)) );
  connect( _slider, SIGNAL(valueChanged(int)), this, SLOT(setEffect(int)));
  

  startTimer(50);
}

void 
QJSlider::setEffect(int value)
{
  if (_on) {
    _effect->setValue(value);
    if (_midiOut != 0) 	
      _midiOut->handle(*_effect);
  }
}


void 
QJSlider::selectEffect(bool on)
{
  _slider->setEnabled(on);
  if (_on)   {
    if (on) {
      if (_midiOut != 0) {
	_effect->setOn(true);
	_midiOut->handle(*_effect);
      }
    } else {
      _effect->setOn(false);
      _midiOut->handle(*_effect);
    }
  }
}


void 
QJSlider::timerEvent(QTimerEvent *)
{
  if (_effect == 0) return;
  int valueTmp = _effect->value();
  if (valueTmp == _slider->value()) return;
  if (_on)
    {
      _on=FALSE;
      _slider->setValue(valueTmp);
      _on=TRUE;
    }
  else
    _slider->setValue(valueTmp);
}

void 
QJSlider::resizeEvent( QResizeEvent * )
{
  // 40  2 <  width-112    > 2  72

    _lcd->setGeometry( 0, 0, 40, height()+2);
    _slider->setGeometry( 42, 0, width()-116, height());
    _label->setGeometry( width()-72,0,72,height());
}













