#include "QJStaveNoteDraw.h"
#include "rep/JStaveNoteInfo.h"
#include "QJDrawComponents.h"
#include "rep/JStave.h"
#include "jam/JBeatList.h"

QJStaveNoteDraw::QJStaveNoteDraw(const JBeat &,
				 const JDuration &duration,
				 const JStaveNoteInfo &info,
				 JNoteStyle noteStyle)
  :QJListDraw(2+info.nRungs())
{

  QJDrawComponents *components=QJDrawComponents::the();
  const QJDraw* d=components->note(duration,noteStyle);
  
  int j=0;

  add(j++,d);

  const QJDraw* e=0;

  switch(info.accidental())
    {
    case SHARP:
      e=components->component(QJDrawComponents::SHARP);
      break;
    case FLAT:
      e=components->component(QJDrawComponents::FLAT);
      break;
    case NATURAL:
      e=components->component(QJDrawComponents::NATURAL);
      break;
    default:
      //      debug(" OOOPS WHAT WAS THAT ");
      break;
    }

  if (e != 0) add(j++,e,d->x()-e->width()-2,-8);

  if (info.nRungs() <= 0 ) return;

  e=components->component(QJDrawComponents::LADDER);

  int inc=components->size()/8;

  for(int i=info.startLadder() ; i <= info.endLadder() ; i += 2)
    {
      int y= (i-info.line())*inc;
      add(j++,e,(d->x()-2),-y);
    }
}









QJStaveRestDraw::QJStaveRestDraw(const JBeat &,
				 const JDuration &duration,
				 const JStaveNoteInfo &info)
  :QJListDraw(2+info.nRungs())
{

  QJDrawComponents *components=QJDrawComponents::the();
  const QJDraw* d=components->rest(duration);
  
  int j=0;

  add(j++,d);

  const QJDraw* e=0;


  if (e != 0) add(j++,e,d->x()-e->width()-2,-8);

  if (info.nRungs() <= 0 ) return;

  e=components->component(QJDrawComponents::LADDER);

  int inc=components->size()/8;

  for(int i=info.startLadder() ; i <= info.endLadder() ; i += 2)
    {
      int y= (i-info.line())*inc;
      add(j++,e,(d->x()-2),-y);
    }
}






