#ifndef _QJTrackScore_H
#define _QJTrackSocre_H

/*!
 \class QJTrackScore QJTrackScore.h
 \brief Qt view of a track 

*/  

#include <qwidget.h>
#include <qpixmap.h>
#include "base/JOSTemplate.h"
#include "rep/JBeat.h"
#include "rep/JLRRep.h"


class JTrack;
class JTrackUpdate;
class QJScorePainter;
class JStave;
class JBeatToX;
class JStaveToY;
class JFocus;
class JCursor;
class JMeter;
class JContext;

class QJTrackScore : public QWidget
{
  Q_OBJECT
public:
  QJTrackScore(JBeatToX *beatToX,
	       JContext *context,
	       QWidget *parent,
	       const char *name);

  ~QJTrackScore();

  void setTrack(const JTrack *);

  void rebuild();

  void update(JLRRep lr);

  //! ensure cursor is correct.
  void assertCursor();

  const char *name() const { return QWidget::name(); }

protected:
  void mousePressEvent(QMouseEvent *);
  void mouseReleaseEvent(QMouseEvent *);
  void mouseMoveEvent(QMouseEvent *);
  void keyPressEvent(QKeyEvent *);

public:
  signals:
  
  void aKeyPressEvent(QKeyEvent *);
  void aMousePressEvent(QMouseEvent *);
  void aMouseReleaseEvent(QMouseEvent *);
  void aMouseMoveEvent(QMouseEvent *);

private:

  //  void rebuild();
  void resizeEvent(QResizeEvent *);
  void paintEvent(QPaintEvent *);

  QJScorePainter * _painter;
  const JTrack *   _track;
  QPixmap          _pixmap;
  JStave *         _stave;
  JBeatToX *       _beatToX;
  JStaveToY *      _staveToY;
  JContext *       _context;
};


#endif



