#ifndef _JMidiOutEvent_H
#define _JMidiOutEvent_H

#include "JMidiType.h"
#include "assert.h"
#include "JMidiInEvent.h"


class JReader;

#define WILD_ID  (-1)

class JMidiOutEvent
{
public:

  JMidiOutEvent(JMidiInEvent in):
    _dev(0),
    _chn(in.channel()),
    _type(midiInToOut(in.type())),
    _index(in.index()),
    _value(in.value()) 
  {;}

  JMidiOutEvent(JMidiOutType type,int index=0,int value=0)
   : _dev(0),_chn(0),_type(type),_index(index),_value(value) {;}

  JMidiOutType::Type type() const { return _type.type(); }

  int         deviceId()  const { return _dev; }
  void        setDeviceId(int id) { _dev=id; }

  int         channelId()  const { return _chn; }
  void        setChannelId(int id) { _chn=id; }

  int         index() const { return _index; }
  void        setIndex(int i) { assert(i > 0 && i <= 128); _index=i; }
  void        setValue(int value) { _value=value; }
  int         value() const {return _value; } 


  bool        read(JReader &in);

  void        debugOut(ostream &) const;
private:

  int           _dev;
  int           _chn;
  JMidiOutType   _type;
  int           _index;
  int           _value;

};


ostream & operator << (ostream &,JMidiOutEvent e);

#endif
