#include <istream.h>
#include "JReader.h"
#include "rep/JBeat.h"
#include <string.h>


JReader::JReader(istream &in):_in(in)
{
  _buff[0]=0;  
}

bool
JReader::getToken(JToken &t)
{

  if (_in.fail()) return false;

  
  getString(_buff,60);

  if (_in.fail()) return false;
  if (_in.eof()) return false;

  if (strncmp(_buff,"$Composition",12)==0) {
    t=T_Composition;  
  } else if (strncmp(_buff,"$Track",6)==0) {
    t=T_Track;  
  } else if (strncmp(_buff,"$Voice",6)==0) {
    t=T_Voice;  
  } else if (strncmp(_buff,"$Phrase",7)==0) {
    t=T_Phrase;  
  } else if (strncmp(_buff,"$End",4)==0) {
    t=T_End;  
  } else {
    cerr << " Unknown token string " << _buff << endl;
    return false;
  }
  
  return true;
}

const char *
JReader::last() const
{
  return _buff;
}

bool
JReader::getString(char *c,int n)
{
  *c=0;
  if (_in.bad()) return false; 
  if (_in.eof()) return false;
  
  _in >> _buff;

  if (_in.fail()) return false; 
  strncpy(c,_buff,n);
  return true;
}

bool
JReader::fail() const
{
  return _in.fail();
}

bool
JReader::eof() const
{
  return _in.eof();
}


bool
JReader::getInt(int &i)
{
  i=0;
  if (_in.fail()) return false;
  if (_in.eof()) return false;

  _in >> i;
  if (_in.fail()) return false;

  return true;
}

bool
JReader::getBeat(JBeat &b)
{
  if (_in.fail()) return false;
  if (_in.eof()) return false;

  double d;
  _in >> d;
  if (_in.fail()) return false;
  b=JBeat(d);
  return true;
}

bool
JReader::getDuration(JDuration &b)
{
  if (_in.fail()) return false;
  if (_in.eof()) return false;

  double d;
  _in >> d;
  if (_in.fail()) return false;
  b=JDuration(d);
  return true;
}





