#include "JRepeatPhraseSequencer.h"
//#include "JNoteOnEvent.h"
#include "JClickTrack.h"
#include "JTimeUtilities.h"
#include "JPlayer.h"

JRepeatPhraseSequencer::JRepeatPhraseSequencer(const JRepeatPhrase *phrase,
					       JPlayer *handler)
  :_phrase(phrase),
   _duration(phrase->duration()),
   _beat(0),
   _startBeat(0),
   _handler(handler)
{
  _ptr   = _phrase->head()->next();
  assert(!_ptr->isTerminator());
}


JBeat
JRepeatPhraseSequencer::gotoBeat(const JBeat &b)
{

  //  while(
  JBeat lb = b%_duration;

  // TODO: Assumes start of loop is at zero beat ?
  // startBeat is first beat for this loop.
  _startBeat=JBeat(b-lb);
  _ptr=_phrase->head();

  while(1) {
    while(!(_ptr=_ptr->next())->isTail()) {
      if (_ptr->beat() >= lb) {
	_beat = _startBeat + _ptr->beat();
	return _beat;
      }
    }
    // Untidy hack follows (2 lines)
    lb=lb-_duration;
    _ptr=_phrase->head();
  }

  assert(0);
  return JBeat::endOfTime();
}

JBeat
JRepeatPhraseSequencer::execute()
{
  assert(!_ptr->isTerminator());


  ((JHandler<const JEvent *,void> *)_handler)->handle(_ptr); 

  //  _handler->handle(_ptr);

  _ptr=_ptr->next();

  if (_ptr->isTail()){
    _ptr=_phrase->head()->next();
    _startBeat += _duration;
  }

  _beat=_startBeat+_ptr->beat();

  return _beat;
}









