#include "JMidiInEvent.h"
#include "assert.h"
#include <ostream.h>


ostream & operator <<(ostream &out,const JMidiInEvent &event)
{
  event.debugOut(out);
  return out;
}


// JMidiInEvent::JMidiInEvent(const JMidiInEvent &cloneMe)
// {
  

// }

void
JMidiInEvent::debugOut(ostream &out) const
{
  switch(type())
    {
    case NOTEON: 
      out << " NoteOn";
      out << " Pitch: " << (int)pitch();
      out << " Vel: "  << (int)velocity();
      break;

    case NOTEOFF:
      out << " NoteOff";
      out << " Pitch: " << (int)pitch();
      break;

    case CONTROLLER:
      out << " Controller:" << (int)controller();
      out << " Value: " << (int)value();
      break;
      
    case PITCHBEND:
      out << " PitchBend:" << (int)pitchBend();
      break;
      
    case PROGRAM:
      out << " Program:" << (int)program();
      break;
      
    case PRESSURE:
      out << " Pressure:" << (int)value();
      break;

    default:
      out << " UNKNOWN:" << (int)value();
    }
}



int
JMidiInEvent::value() const
{
  switch(type())
    {
    case NOTEON: 
      return velocity();
      break;

    case NOTEOFF:
      return 0;
      break;

    case CONTROLLER:
      return controllerValue();
      break;
      
    case PITCHBEND:
      return pitchBend();
      break;
      
    case PROGRAM:
      return program();
      break;
      
    case PRESSURE:
      return pressure();
      break;

    default:
      assert(0);
      return 0;
    }
}

