#include "JBPT.h"
#include "JToBPT.h"

JBPT::JBPT(const JToBPT *toBPT,const char *name)
  :_toBPT(toBPT),
   JName(name),
   _ticksInPulse(toBPT->ticksInPulse())
{
  setBar(0);
}

//! If my reference frame changes
void 
JBPT::handle(const JToBPT *toBPT)
{
  assert( _toBPT == toBPT);
  _toBPT = toBPT;
  setBeat(_beat);
}

void 
JBPT::addTicks(int ticks,bool quiet)
{
  setBeat(_beat + JDuration(0,ticks,_ticksInPulse),quiet);
}

void 
JBPT::addPulses(int pulses,bool quiet)
{
  setBeat( (double)((int)_beat.rep() + pulses),quiet);
}

void 
JBPT::addBars(int bars,bool quiet)
{
  _bar += bars;
  setBeat(_toBPT->beatAtBar(_bar),quiet);

}

void 
JBPT::setBar(int bar,bool quiet)
{
  _bar        = bar;
  setBeat(_toBPT->beatAtBar(_bar),quiet);
}


// void
// JBPT::rebuildBeat(bool quiet)
// {

//   _pulsesInBar = _toBPT->pulsesInBar(_bar);
//   double rep   = _toBPT->beatAtBar(_bar).rep() + (double)_pulse + (double)_tick/(double) _ticksInPulse - 1 ;
//   _beat        = JBeat(rep);

//   if (!quiet)  notifyObservers(this);
// }

void
JBPT::setBeat(JBeat beat,bool quiet)
{
  _beat          = beat;
  _bar           = _toBPT->barContaining(beat);
  _ticksInPulse  = _toBPT->ticksInPulse();
  JBeat barStart = _toBPT->beatAtBar(_bar);
  _pulsesInBar   = _toBPT->pulsesInBar(_bar);

  double rPulse = beat.rep() - barStart.rep() + 1;
  _pulse = (int)rPulse;
  _tick  = (int)( (rPulse - _pulse)*_ticksInPulse);

  if (!quiet) notifyObservers(this);
}







