#ifndef _JConductor_H
#define _JConductor_H

#include "JTimerClient.h"
//#include "jam/JMetaSequencer.h"

#include "base/JOSTemplate.h"
#include "rep/JBeat.h"

#include "command/JPlayerCommand.h"
#include "command/JConductorCommand.h"

class JSequence;
class JSequencer;
class JCommand;
class JTimer;
class JScheduler;


class JConductor:public JObserver<JSequencer *,void>,
		 public JObserver<JConductorCommand ,void>,
		 public JSubject <JPlayerCommand  ,void>,
		 public JTimerClient
{
public:

  JConductor(JSequence *sequence);

  virtual ~JConductor();
  void handle(JSequencer *);
  void handle(JConductorCommand);

  /// JTimerClient
  void interuptHandler(int);

  void  setCurrentBeat(JBeat beat);
  void  setLooping(bool on);

  void  setLeft(JBeat left);  
  void  setRight(JBeat right);


  JBeat currentBeat() const  { return _nowBeat;  }
  bool  isPlaying() const;
  //
  bool  isLooping() const { return _loop; }

  JBeat left() const { return _left; }
  JBeat right() const { return _right; }

  const char *name() const { return "Conductor";}


private:

  void start();  
  void stop(bool purgeSeq);


protected:

  //TODO move somewhere esle
  JBeat           _left;       // default start
  JBeat           _right;       // default end
  // ---

  JBeat          _start;
  JBeat          _end;

  JBeat          _nextBeat;       // next Beat to be played

  JBeat          _nowBeat;        // last beat played
  JBeat          _retBeat;        // last beat played

  bool           _loop;           // TODO:

  JSequence *    _defaultSequence; // PLAY will play defualtSequencer

  JSequencer *   _mySequencer;      // my current sequencer

  JTimer *       _timer;
  JScheduler *   _scheduler;
  bool           _lock;
  JBeat          _beatAfterEnd;
};


#endif





