#ifndef _JFocus_H
#define _JFocus_H


/*!
  \class JFocus JFocus.h
  \brief 

  */

#include "assert.h"
#include "base/JOSTemplate.h"


class JTrack;
class JPart;
class JPhrase;
class JComposition;
class JVoice;
class JEvent;
class JFocusEvent;

class JFocus:public JSubject<const JFocus *,void>
{


public:

  JFocus(JComposition *);
  virtual ~JFocus(){;}

  void touchState();

  JComposition *composition() { return _composition; }

  JTrack * track() const;
  //  JTrack * nextTrack(bool quiet=false);
  //  JTrack * prevTrack(bool quiet=false);

  JPart * part() const ;
  JPart * nextPart(bool quiet=false);
  JPart * prevPart(bool quiet=false);

  JPhrase * phrase() const;
  JPhrase * nextPhrase(bool quiet=false);
  JPhrase * prevPhrase(bool quiet=false);

  JVoice * voice() const;

  void    setTrack(JTrack *track,bool quiet=false);
  void    setPart(JPart *part,bool quiet=false);
  void    setPhrase(JPhrase *phrase,bool quiet=false);

  const char *name() const { return "Focus";  }

  
protected:

  JComposition * _composition;
  JTrack       * _track;
  JPart        * _part;
  JPhrase  *     _phrase;
  JVoice *       _voice;  
};


#endif
