#ifndef _JPrototypeGesture_H
#define _JPrototypeGesture_H

#include "JSequence.h"
#include "JStyle.h"
#include "JName.h"


class JScorePainter;
class JNotator;
class JScorePainter;
class ostream;
class JNotePrototypeGesture;
class JReader;

class JPrototypeGesture 
{

protected:
  virtual ~JGesture();
  virtual JGesture *    clone() const=0;

  virtual JNotator *    createNotator(JScorePainter *) const = 0;
  virtual  void shiftBy(JDuration d) { _start += d; }

  virtual  bool         tweak(double val=1.0,int index=0);
  virtual  const char **tweakNames() const;
  virtual  bool         write(ostream &) const=0;
  virtual  bool         read(JReader &)=0;
  virtual  const char * typeName() const=0;

  JBeat    start() const { return _start; }
  bool     isType(const char *name);
  bool     writeBase(ostream &) const;
  bool     readBase(JReader &);

  JGesture * next() { return _next; }
  JGesture * prev() { return _prev; }

  // hack city
  virtual JNoteGesture *noteGesture() { return 0; }

protected:

  friend class JGestureList;
  friend class JGestureListIterator;

  JBeat      _start;

  JGesture * _prev;
  JGesture * _next;
  
};

inline
bool
JGesture::tweak(double,int)
{
  return false;
}

#endif


