#include <iostream.h>
#include "JSweepGesture.h"
#include "seq/JSweepSequencer.h"
#include "rep/JReader.h"

JSweepGesture::JSweepGesture(JBeat start,
			     JDuration d,
			     JMidiOutEvent e,
			     int startVal,
			     int endVal)
    :JGesture(start),
     _startVal(startVal),
     _endVal(endVal),
     _d(d),
     _e(e)
{
};


JGesture *
JSweepGesture::clone() const
{
  return new JSweepGesture(_start,_d,_e,_startVal,_endVal);
};



JSequencer *
JSweepGesture::createSequencer(JPlayer *p) const
{
  return new JSweepSequencer(this,p);
}


bool
JSweepGesture::tweak(double val,int index)
{

  int ival = (int)val;

  switch(index) {

  case 0:
    _e.setIndex((_e.index()+ival)%128);
    return true;

  default:
    return false;

  }
}

const char **
JSweepGesture::tweakNames() const
{
  static const char *names[]={"cntrl",0};
  return names;

}

bool
JSweepGesture::write(ostream &out) const
{
  out << typeName() 
      << " " 
      <<  _start 
      << " " 
      << _e 
      << " "
      << _d 
      <<" "
      << _startVal 
      <<" "
      << _endVal;

  return !out.fail();
}


bool
JSweepGesture::read(JReader &in)
{
  in.getBeat(_start);
  _e.read(in);
  in.getDuration(_d);
  in.getInt(_startVal);
  in.getInt(_endVal);
  return in.fail();
}








