#ifndef _JSweepGesture_H
#define _JSweepGesture_H

#include "JGesture.h"
#include "rep/JMidiOutEvent.h"

class JSweepGesture:public JGesture
{
public:
  JSweepGesture(JBeat start,
		JDuration d,
		JMidiOutEvent e,
		int startVal,
		int endVal);

  JGesture *    clone() const;
  bool          write(ostream &) const;
  bool          read(JReader &);
  const char *  typeName() const { return "$Sweep";}
  JSequencer *  createSequencer(JPlayer *) const;
  JBeat         end() const;
  JMidiOutEvent event() const { return _e; }
  JDuration     duration() const { return _d; }
  int           startValue() const;
  int           endValue() const;
  bool          tweak(double val,int index);
  const char ** tweakNames() const;

private:

  int           _startVal;
  int           _endVal;
  JDuration     _d;
  JMidiOutEvent _e;
};

inline
int
JSweepGesture::startValue() const
{
  return _startVal;
}

inline
int
JSweepGesture::endValue() const
{
  return _endVal;
}

inline
JBeat
JSweepGesture::end() const
{
  return _start + _d;
}


#endif

