#ifndef _JTime_H
#define _JTime_H 



///
class ostream;
class JBeat;
class JTempo;

class JTime
{
public:
  ///
  JTime(){;} 
  ///
  JTime(long t):_t(t){;}

  // DO NOT USE THIS ONLY FOR LOW LEVEL STUFF
  long glitchs() const { return _t; }
  ///
  bool operator >(const JTime &a) const { return _t > a._t;}
  ///
  bool operator <(const JTime &a) const { return _t < a._t;}
  ///
  bool operator >=(const JTime &a) const { return _t >= a._t;}
  ///
  bool operator <= (const JTime &a) const { return _t <= a._t;}
  ///
  bool operator != (const JTime &a) const { return _t != a._t;}
  ///
  bool operator == (const JTime &a) const { return _t == a._t;}

  ///
  void operator += (JTime a) { _t += a._t;}
  ///
  void operator -= (JTime a) { _t -= a._t;}
  friend JTime operator /(const JTime &t, int a);
  friend JTime operator *(const JTime &t, int a);
  friend JTime operator +(const JTime &t, const JTime &b);
  friend JTime operator -(const JTime &t, const JTime &a);
  
  ///
  ///  operator long() const { return _t;} 

  ///
  static JTime &endOfTime() { return _ENDOFTIME; }
  ///
  static JTime &startOfTime() { return _STARTOFTIME; }

  ///
  friend ostream & operator << (ostream &out,const JTime &t);
  friend JBeat operator /(const JTime &t,const JTempo &tempo);

protected:
  ///
  static JTime _ENDOFTIME;
  ///
  static JTime _STARTOFTIME;
  ///
  long _t;
public:
  static const long GLITCHPERSEC;
};

inline
JTime operator +(const JTime &t, const JTime &b)
{
  return JTime(t._t + b._t);
}

inline
JTime operator -(const JTime &t, const JTime &b)
{
  return JTime(t._t - b._t);
}

inline
JTime operator /(const JTime &t, int a)
{
  return JTime(t._t/a);
}


inline
JTime operator *(const JTime &t, int a)
{
  return JTime(t._t*a);
}

///
ostream & operator << (ostream &out,const JTime &t);


#endif



