extern "C" {

#include <features.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>

  // <HACK>
  // My sched.h is broken I wonder if it works at all ? :-(
  // Here are the bits I need to link in the   sched_setscheduler

#define SCHED_OTHER    0
#define SCHED_FIFO     1
#define SCHED_RR       2

struct sched_param
{
  int sched_priority;     /* Process execution scheduling priority */
};

extern int sched_setscheduler __P((pid_t __pid, int __policy,
	const struct sched_param *__param));

  /// <HACK END>

}

// ---------------------------------------------------

#include <iostream.h>

#include "JApplication.h"
#include "jam/JDeviceManager.h"
#include "jam/JDebugDevice.h"
#include "xbeep/JX11BeepDevice.h"

#ifdef J_HAVE_OSS
#include "oss/JOSSDeviceManager.h"
#endif


#include "it/JITScheduler.h"  // is this an ifdef ?? tough if you aint't got it


#ifdef J_HAVE_MIDIBUS
#include "midibus/JMidiBusDevice.h"
#endif

JApplication::JApplication()
{

  JDeviceManager *manager=JDeviceManager::the();
  struct sched_param prio;

  prio.sched_priority = 50;
  sched_setscheduler(getpid(),SCHED_FIFO,&prio);
  //  nice(-15);

#ifdef J_HAVE_OSS
  _scheduler = new JITScheduler;
  _ossDeviceManager = new JOSSDeviceManager(manager,_scheduler);
  _scheduler->launch(JTime(10));
#endif

#ifdef J_HAVE_MIDIBUS
  manager->addOutDevice(new JMidiBusDevice());
#endif

  manager->addOutDevice(new JX11BeepDevice());
  manager->addOutDevice(new JDebugDevice(cout));


}


JApplication::~JApplication()
{

#ifdef J_HAVE_OSS
  delete  _ossDeviceManager;
  delete  _scheduler;
#endif

}








