#include "QJChannelWidget.h"
#include "QJSlider.h"
#include "jam/JEffect.h"
#include "jam/JEffectList.h"
#include "jam/JVoice.h"
#include "jam/JMapper.h"
#include "jam/JDeviceManager.h"

QJChannelWidget::QJChannelWidget(JVoice *voice, 
				 QWidget *parent, 
				 const char *name )
  : QWidget( parent, name ),_slider(0)
{
  	rebuild(voice);
}


void
QJChannelWidget::rebuild(JVoice *voice)
{

  if(_slider != 0 ) delete [] _slider;

  JEffectList * effectList = voice->effectList();

  int n=effectList->count();

  _slider = new QJSlider *[n];
  
  JEffectListIterator effects(effectList);
  
  JEffect *effect;

  int i=0;
  while( (effect=effects.next()) != 0) {
    assert(i < n);
    _slider[i]=new QJSlider(effect , voice , this);
    _slider[i]->setGeometry(10,4+i*16,250,16);
    i++;
  }

  adjustSize();
}

QJChannelWidget::~QJChannelWidget()
{
  delete [] _slider;
}






