#include <stdlib.h>
#include <stdio.h>


#include <qpalette.h>
#include <qlcdnum.h>
#include <qlayout.h>
#include <qbitmap.h>
#include <qpushbt.h>
#include <qaccel.h>
#include <qlabel.h>
#include <qslider.h>
#include <qscrbar.h>

#include "jam/JConductor.h"
#include "jam/JContext.h"
#include "jam/JTimer.h"
#include "jam/JBPT.h"

#include "QJTransportWidget.h"
#include "QJBPTWidget.h"
#include "jam/JVoiceRecorder.h"

QJTransportWidget::QJTransportWidget(JContext *context,
				     QWidget *parent,
				     WFlags   f)
  :QWidget(parent,"Transport",f),
   _block(false),
   _time(context->time()),
   _left(context->left()),
   _right(context->right()),
   _context(context)
{

  QWidget *w;

  _left->attach(this);
  _right->attach(this);
  
  const QColorGroup &old=colorGroup();
  
  QHBoxLayout  *layout = new QHBoxLayout(this,0);

  QColorGroup bpmColor(green,
		       black,
		       old.light(),
		       old.dark(),
		       old.mid(),
		       green, // old.text(),
		       old.base());
  

  QBoxLayout  *bpmLay  = new QHBoxLayout();
  layout->addLayout(bpmLay);

  int bpm = (int)JTimer::the()->tempo();

#if 1
  _bpmLcd = new QLCDNumber(3,this,"lcd");
  _bpmLcd->setPalette(QPalette(bpmColor,bpmColor,bpmColor));
  _bpmLcd->setSegmentStyle(QLCDNumber::Flat);
  _bpmLcd->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  _bpmLcd->setFixedSize(30,30);
  QScrollBar *slider   = new QScrollBar(20,220,1,5,bpm,QScrollBar::Vertical,this);
  slider->setFixedSize(12,32);
  slider->raise();
  bpmLay->addWidget(slider);
  bpmLay->addWidget(_bpmLcd);
#else
  _bpmKDE = new KNumericSpinBox(this);
  _bpmKDE->setValue(bpm);
  bpmLay->addWidget(_bpmKDE);
#endif



  QVBoxLayout * tb     = new QVBoxLayout();
  layout->addLayout(tb);

  QHBoxLayout * lr     = new QHBoxLayout();
  tb->addLayout(lr);


  // First the left time mark ----------------------
  QJBPTWidget *bptWid = new QJBPTWidget(this,_left);
  bptWid->setFocusPolicy(StrongFocus);

  w= new QLabel("L",this);
  w->setFixedSize(14,10);
  lr->addWidget(bptWid);
  lr->addWidget(w);

  // First the left time mark ----------------------
  lr = new QHBoxLayout();
  tb->addLayout(lr);

  bptWid = new QJBPTWidget(this,_right);
  bptWid->setFocusPolicy(StrongFocus);

  w= new QLabel("R",this);
  w->setFixedSize(14,10);
  lr->addWidget(bptWid);
  lr->addWidget(w);


  // Now the buttons ----------------------
  
  _loop = new QPushButton("LOOP",this);
  _loop->setToggleButton(true);
  _loop->setMaximumSize(50,50);
  layout->addWidget(_loop);

  QColorGroup timeColor(green,
			black,
			old.light(),
			old.dark(),
			old.mid(),
			green, // old.text(),
			old.base());
  

  _timeLcd = new QLCDNumber(7,this,"lcd");
  _timeLcd->setPalette(QPalette(timeColor,timeColor,timeColor));
  _timeLcd->setSegmentStyle(QLCDNumber::Flat);
  _timeLcd->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  _timeLcd->setFixedSize(60,30);
  layout->addWidget(_timeLcd);

#include "bitmaps/transport/rewind.xbm"
  QBitmap pm(rewind_width,rewind_height,(unsigned char *)rewind_bits,TRUE);
  pm.setMask(pm);
  _rewind =new QPushButton("REWIND",this);
  _rewind->setPixmap(pm);
  _rewind->setMaximumSize(50,50);
  _rewind->setAccel(Key_Home);
  //  _rewind->setAutoRepeat(true);
  layout->addWidget(_rewind);


#include "bitmaps/transport/ffwd.xbm"
  QBitmap pmf(ffwd_width,ffwd_height,(unsigned char *)ffwd_bits,TRUE);
  pmf.setMask(pmf);
  _forward =new QPushButton("FORWARD",this);
  _forward->setPixmap(pmf);
  _forward->setMaximumSize(50,50);
  _forward->setAutoRepeat(true);
  layout->addWidget(_forward);

  
#include "bitmaps/transport/play.xbm"
  QBitmap pmp(play_width,play_height,(unsigned char *)play_bits,TRUE);
  pmp.setMask(pmp);
  
  _play = new QPushButton("PLAY",this);
  _play->setToggleButton(true);
  _play->setPixmap(pmp);
  _play->setMaximumSize(50,50);
  //  _play->setAccel(Key_Tab);
  layout->addWidget(_play);
  
  QColorGroup playColor(old.foreground(),
			old.background(),
			old.light(),
			old.dark(),
			old.mid(),
			QColor(50,155,20), // old.text(),
			old.base());
  
  _play->setPalette(QPalette(playColor,playColor,playColor));

#include "bitmaps/transport/record.xbm"
  QBitmap pmr(record_width,record_height,(unsigned char *)record_bits,TRUE);
  pmr.setMask(pmr);
  _record =new QPushButton("REC",this);
  _record->setToggleButton(true);
  _record->setPixmap(pmr);
  QColorGroup recordColor(old.foreground(),
			  old.background(),
			  old.light(),
			  old.dark(),
			  old.mid(),
			  QColor(200,0,0), // old.text(),
			  old.base());

  _record->setPalette(QPalette(recordColor,recordColor,recordColor));
  _record->setMaximumSize(50,50);
  layout->addWidget(_record);


  layout->activate();

  connect(_record,SIGNAL(clicked()),SLOT(record()));
  connect(_play,SIGNAL(clicked()),SLOT(startstop()));
  connect(_rewind,SIGNAL(clicked()),SLOT(rewind()));
  connect(_forward,SIGNAL(pressed()),SLOT(forward()));
  connect(_loop,SIGNAL(clicked()),SLOT(loop()));

  connect(slider,SIGNAL(valueChanged(int)),SLOT(tempo(int)));

  setFixedSize(400,32);
  startTimer(100);
}

void
QJTransportWidget::handle(const JBPT *bpt)
{
  if (bpt->isNamed("left"))
    _context->conductor()->setLeft(bpt->beat());
  else
    _context->conductor()->setRight(bpt->beat());
}


void 
QJTransportWidget::tempo(int i)
{
  assert(i < 240);

  double bpm = (double)(240-i);
  JTimer::the()->setTempo(bpm);
}

void
QJTransportWidget::timerEvent(QTimerEvent *)
{
  

  assertState();

  int bpm=(int)JTimer::the()->tempo();

  _bpmLcd->display(bpm);

  if (_beatLast == _context->conductor()->currentBeat()) return;

  _beatLast = _context->conductor()->currentBeat();

  _time->setBeat(_beatLast);
  QString buff;
  buff.sprintf("%3d:%1d:%03d",_time->bar(),_time->pulse(),_time->tick());
  _timeLcd->display(buff);


  emit playTimeNotify(_beatLast);
}


void 
QJTransportWidget::assertState()
{
  _block = true;

  
  if (_context->conductor()->left()  != _left->beat())
    _left->setBeat(_context->conductor()->left());

  if (_context->conductor()->right()  != _right->beat())
    _right->setBeat(_context->conductor()->right());
    
  if (_context->conductor()->isPlaying()) {
     _play->setOn(true);
  } else {
     _play->setOn(false);
  }


  if (_context->conductor()->isLooping()) {
    _loop->setOn(true);
  } else {
     _loop->setOn(false);
  }


  if (_context->recorder()->isArmed()) {
     _record->setOn(true);
  } else {
     _record->setOn(false);
  }

  _block=false;

}



void
QJTransportWidget::startstop()
{

  if (_context->conductor()->isPlaying()) {
    ((JObserver<JConductorCommand,void> *)(_context->conductor()))->handle(JConductorCommand::STOP);
    ((JObserver<JRecorderCommand,void> *)(_context->recorder()))->handle(JRecorderCommand::RECORDOFF);
  } else {
    _context->conductor()->handle(JConductorCommand::START);
  }

}

void
QJTransportWidget::record()
{
  if (_context->recorder()->isArmed()) {
    ((JObserver<JRecorderCommand,void> *)_context->recorder())->handle(JRecorderCommand::RECORDOFF);
  }  else {
    ((JObserver<JRecorderCommand,void> *)_context->recorder())->handle(JRecorderCommand::RECORDON);
  }
}


void
QJTransportWidget::loop()
{
  if ( _block ) return;
  if (_loop->isOn())
    _context->conductor()->setLooping(true);
  else
    _context->conductor()->setLooping(false);
}



void
QJTransportWidget::forward()
{
  JBeat beat = _context->conductor()->currentBeat() + JDuration(1);
  _context->conductor()->setCurrentBeat(beat);
}



void
QJTransportWidget::rewind()
{

  ((JObserver<JConductorCommand,void> *)_context->conductor())->handle(JConductorCommand::REWIND);
  ((JObserver<JRecorderCommand,void> *)_context->recorder())->handle(JRecorderCommand::RECORDOFF);

}



#if 0

#include <qapp.h>

int main( int argc, char **argv )
{
  QApplication a( argc, argv );
  
  QJTransportWidget myWidget(0,0,0);

  a.setMainWidget( &myWidget );

  myWidget.show();

  return a.exec();
}


#endif
