#ifndef _QJTransportWidget_H
#define _QJTransportWidget_H

/*!
 \class QJTransportWidget QJTransportWidget.h

*/


#include <qwidget.h>

#include "rep/JBeat.h"
#include "base/JOSTemplate.h"

class JMeter;
class JTimer;
class QJToolBox;
class QLCDNumber;
//class QGridLayout;
class QPushButton;
class JConductor;
class JBeat;
class JBPT;
class JContext;
class KNumericSpinBox;

class QJTransportWidget:public QWidget,
			public JObserver<const JBPT *,void>
{
  Q_OBJECT
public:
  QJTransportWidget(JContext *,
		    QWidget *parent=0,
		    WFlags f=0);

  ~QJTransportWidget(){;}
  void handle(const JBPT *);

  const char *name() const { return QWidget::name(); }
protected:

  void timerEvent(QTimerEvent *);

  QLCDNumber *  _bpmLcd;

  QLCDNumber *  _timeLcd;

  //  QGridLayout *  _layout;

  QPushButton * _play;

  QPushButton * _record;

  QPushButton * _stop;

  QPushButton * _rewind;

  QPushButton * _forward;

  QPushButton * _loop;


public:
signals:
  void playTimeNotify(JBeat beat);

protected slots:
  void startstop();
  void rewind();
  void forward();
  void record();
  void loop();
  void tempo(int);

private:

  void assertState();
  //  void sendCommand();
  JBeat          _beatLast;
  bool           _block;
  JBPT *         _time;
  JBPT *         _left;
  JBPT *         _right;
  JContext *     _context;
  //  JCommand       _cmd;
};



#endif




