#include "JEffectEventSequencer.h"
#include "jam/JEffectEventGesture.h"
#include "jam/JPlayer.h"

JEffectEventSequencer::JEffectEventSequencer(const JEffectEventGesture *e,
					     JPlayer *player)
  :_e(e),
   _player(player),
   _next(e->start())
{
  assert(_player != 0);
}

JBeat
JEffectEventSequencer::nextBeat()
{
  return _next;
}

JBeat 
JEffectEventSequencer::gotoBeat(const JBeat &when)
{
  if (when <= _e->start()) {
    _next=_e->start();
  } else {
    _next=JBeat::endOfTime();
  }
  return _next;
}

JBeat 
JEffectEventSequencer::execute()
{
  ((JHandler  <JMidiOutEvent, void> *)_player)->
    handle(_e->event());
  _next=JBeat::endOfTime();
  return _next;
}





