/*******************************************/
/*  Matlab MAT File Output Class,          */
/*  by Tim Stilson, 1996                   */
/*  based on code by Perry R. Cook, 1996   */
/*  This Object opens a Matlab MAT file    */
/*  Creates a Matrix to contain the        */
/*  output samples and fills it with       */
/*  buffers of samples.                    */
/*******************************************/


#include "Object.h"
#include "WvOut.h"
#include "mat.h"

#if !defined(__MatWvOut_h)
#define __MatWvOut_h

#define MAT_BUFFER_SIZE 1

class MatWvOut : public WvOut
{
  protected:  
	char *fileName;
	FILE *tmpFile;
    double data[MAT_BUFFER_SIZE]; /* not MY_FLOAT because MAT uses doubles */
    long counter;
    long totalCount;
  public:
    MatWvOut(char *infileName);
    ~MatWvOut();
    long getCounter();
    void tick(MY_FLOAT sample);
};

#endif // defined(__MatWvOut_h)
