/*******************************************/
/*  Real-Time Output Class,                */
/*  by Perry R. Cook, 1995-96              */ 
/*  Separated into just realtime by        */
/*  Tim Stilson, 1996                      */
/*******************************************/

/*******************************************/
/*  SGI Real-Time Wave File Output Class,  */
/*  by Perry R. Cook, 1995-96              */ 
/*  This Object can opens the SGI soundout */
/*  device, and pokes buffers of samples   */
/*  into it.  The real code that does the  */
/*  is originally from Doug Scott of SGI.  */
/*******************************************/

/*******************************************/
/*  USS Real-Time Wave File Output Class,  */
/*  by Tim Stilson, 1996                   */
/*  based on code by Perry R. Cook, 1996   */
/*  This Object opens the USS sound output */
/*  device, and pokes buffers of samples   */
/*  into it.                               */
/*******************************************/


#include "Object.h"
#include "WvOut.h"

#if !defined(__RTWvOut_h)
#define __RTWvOut_h

#if defined(__SGI_REALTIME)

#define RT_BUFFER_SIZE 256

class RTWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RT_BUFFER_SIZE];
    long counter;
  public:
    RTWvOut(char *fileName);
    ~RTWvOut();
    void tick(MY_FLOAT sample);
};

#elif defined(__USS_REALTIME)

#define RT_BUFFER_SIZE 256

class RTWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RT_BUFFER_SIZE];
    long counter;
  public:
    RTWvOut(char *fileName);
    ~RTWvOut();
    void tick(MY_FLOAT sample);
};

#else /* non-RealTime, write NeXT sound files */

/* right now, this else means we can't do realtime output */
/* So... what should we do? */

#define RT_BUFFER_SIZE 1

class RTWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RT_BUFFER_SIZE];
    long counter;
    long totalCount;
  public:
    RTWvOut(char *fileName);
    ~RTWvOut();
    long getCounter();
    void tick(MY_FLOAT sample);
};


#endif

#endif // defined(__RTWvOut_h)
