/*******************************************/
/*  Raw Wave File Output Class,            */
/*  by Perry R. Cook, 1995-96              */ 
/*  For now, This Object can open a raw    */
/*  16bit data (signed integers) file, and */
/*  poke buffers of samples into it.       */
/*******************************************/

/*******************************************/
/*  SGI Real-Time Wave File Output Class,  */
/*  by Perry R. Cook, 1995-96              */ 
/*  This Object can opens the SGI soundout */
/*  device, and pokes buffers of samples   */
/*  into it.  The real code that does the  */
/*  is originally from Doug Scott of SGI.  */
/*******************************************/

/*******************************************/
/*  USS Real-Time Wave File Output Class,  */
/*  by Tim Stilson, 1996                   */
/*  based on code by Perry R. Cook, 1996   */
/*  This Object opens the USS sound output */
/*  device, and pokes buffers of samples   */
/*  into it.                               */
/*******************************************/


#include "Object.h"
#include "WvOut.h"

#if !defined(__RawWvOut_h)
#define __RawWvOut_h

#if defined(__SGI_REALTIME)

#define RAW_BUFFER_SIZE 256
#define RT_BUFFER_SIZE 256

class RawWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RAW_BUFFER_SIZE];
    long counter;
  public:
    RawWvOut(char *fileName);
    ~RawWvOut();
    void tick(MY_FLOAT sample);
};

#elif defined(__USS_REALTIME)

#define RAW_BUFFER_SIZE 256
#define RT_BUFFER_SIZE 256

class RawWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RAW_BUFFER_SIZE];
    long counter;
  public:
    RawWvOut(char *fileName);
    ~RawWvOut();
    void tick(MY_FLOAT sample);
};

#else /* non-RealTime, write NeXT sound files */

#define RAW_BUFFER_SIZE 1
#define RT_BUFFER_SIZE 1

class RawWvOut : public WvOut
{
  protected:  
    FILE *fd;
    short data[RAW_BUFFER_SIZE];
    long counter;
    long totalCount;
  public:
    RawWvOut(char *fileName);
    ~RawWvOut();
    long getCounter();
    void tick(MY_FLOAT sample);
};


#endif

#endif // defined(__RawWvOut_h)
