#include "../H/ugens.h"
#include "../macros/macros.h"

float rsnetc[64][5],amp[64];
int nresons;
#define SIZE 1024
float array[SIZE];

double inputsig(p,n_args)
float *p;
{
	int nsamps,input,output,inchan,outchan,i,j,jj,kontrol;
	float xin[4],out[4],val,q[9],ovamp,*evenv,tabs[3];
	/*start,dur,inskip */
	input=0; output=1;
	nsamps=setnote(p[0],p[1],output);
	setnote(p[2],p[1],input);
	inchan = 0;  outchan = 0;
	evset(p[1],.01,.1,2,q);
	evenv = floc(2);
	tableset(p[1],SIZE,tabs);

	kontrol = SR/500; jj=0;
	for(i=0; i<nresons; i++) rsnetc[i][3] = rsnetc[i][4] = 0;

	for(i=0; i<nsamps; i++) {
		if(!jj--) {
			jj=kontrol;
			ovamp = tablei(i,array,tabs);
			
		}
		if(!GETIN(xin,input)) break;
		for(out[outchan]=0,j=0; j<nresons; j++) {
			RESON(val,xin[inchan],rsnetc[j]);
			out[outchan] += val * amp[j];
		}
		out[outchan] *= ovamp;
		ADDOUT(out,output);
	}
	endnote(output);
}

double noise(p,n_args)
float *p;
{
	int nsamps,input,output,inchan,outchan,i,j;
	float ramp,sig,xin[4],out[4],val;
	float tabs[3],ovamp;
	int jj,kontrol;
	/* start,dur,amp */
	input=0; output=1;
	nsamps=setnote(p[0],p[1],output);
	outchan = 0;
	ramp=p[2];  if(!ramp) ramp=1;
	srrand(.1);
	kontrol = SR/500; jj=0;
	tableset(p[1],SIZE,tabs);

	for(i=0; i<nresons; i++) rsnetc[i][3] = rsnetc[i][4] = 0;

	for(i=0; i<nsamps; i++) {
		if(!jj--) {
			jj=kontrol;
			ovamp = tablei(i,array,tabs);
			
		}

		sig = rrand();
		for(out[outchan]=0,j=0; j<nresons; j++) {
			RESON(val,sig,rsnetc[j]);
			out[outchan] += val * amp[j];
		}
		out[outchan] *= ovamp;
		ADDOUT(out,output);
	}
	endnote(output);
}

double buzzit(p,n_args)
float *p;
{
	int nsamps,len,input,output,inchan,outchan,i,j;
	float hn,bamp,phase,si,*f1,sig,xin[4],out[4],val;
	float tabs[3],ovamp;
	int jj,kontrol;
	/* start,dur,amp,pitch (<15 8ve.pc) */ 
	input=0; output=1;
	nsamps=setnote(p[0],p[1],output);
	outchan = 0;
	bamp=p[2]; 
	si = p[3] < 15 ? cpspch(p[3])*512./SR : p[3] * 512./SR;
	hn = (int)(.5 / (si/512.));
	f1 = floc(1);
	phase = 0;
	kontrol = SR/500; jj=0;
	tableset(p[1],SIZE,tabs);

	srrand(.1);
	for(i=0; i<nresons; i++) rsnetc[i][3] = rsnetc[i][4] = 0;

	for(i=0; i<nsamps; i++) {
		if(!jj--) {
			jj=kontrol;
			ovamp = tablei(i,array,tabs);
			
		}

		BUZZ(sig,bamp,si,hn,f1,phase);
		for(out[outchan]=0,j=0; j<nresons; j++) {
			RESON(val,sig,rsnetc[j]);
			out[outchan] += val * amp[j];
		}
		out[outchan] *= ovamp;
		ADDOUT(out,output);
	}
	endnote(output);
}

double pulseit(p,n_args)
float *p;
{
	int nsamps,input,output,inchan,outchan,i,j;
	float pulse(),phase,pamp,si,sig,xin[4],out[4],val;
	float tabs[3],ovamp;
	int jj,kontrol;
	/* start,dur,pulseamp,pitch (<15 8ve.pc) */
	input=0; output=1;
	phase = 512;
	nsamps=setnote(p[0],p[1],output);
	outchan = 0;
	pamp = p[2];
	kontrol = SR/500; jj=0;
	tableset(p[1],SIZE,tabs);

	si = p[3] < 15 ? cpspch(p[3])*512./SR : p[3] * 512./SR;
	for(i=0; i<nresons; i++) rsnetc[i][3] = rsnetc[i][4] = 0;

	for(i=0; i<nsamps; i++) {
		if(!jj--) {
			jj=kontrol;
			ovamp = tablei(i,array,tabs);
			
		}

		sig = pulse(pamp,si,&phase);
		for(out[outchan]=0,j=0; j<nresons; j++) {
			RESON(val,sig,rsnetc[j]);
			out[outchan] += val * amp[j];
		}
		out[outchan] *= ovamp;
		ADDOUT(out,output);
	}
	endnote(output);
}

double setup(p,n_args)
float *p;
{
	int i,j;
	float first,bw,cf;
	
	first = (p[0] < 15) ? cpspch(p[0]) : p[0];
	bw = p[1] < 0 ? -p[1] * first : p[1];
	rsnset(first,bw,1.,0.,rsnetc[0]);
	printf("centerfreq    bandwidth  relative amp\n");
	amp[0] = p[2];
	printf("%10.4f %10.4f %10.4f\n",first,bw,amp[0]);
	for(i=3,j=1; i<n_args; i += 3)  {
		if(p[i] < 0.) cf = -p[i] * first;
		else  cf = (p[i] < 15) ? cpspch(p[i]) : p[i];
		bw = p[i+1] < 0 ? -p[i+1] * cf : p[i+1];
		amp[j] = p[i+2]; 
		rsnset(cf ,bw ,1.,0.,rsnetc[j]);
		printf("%10.4f %10.4f %10.4f\n",cf,bw,amp[j]); 
		j++;
	}
	nresons = j;
}
float pulse(amp,si,phase)
float amp,*phase,si;
{

	*phase += si;
	if(*phase > 512.) {
		*phase -= 512.;
		return(amp);
	}
	else return(0.);
}
double sl(p,n_args)
float *p;
{
	int i;
	setline(p,n_args,SIZE,array);
}


int NBYTES = 32768;
 
profile()
{
	float p[9];
	int i;
	for(i=0; i<SIZE; i++) array[i] = 1.;
	UG_INTRO("setup",setup);
	UG_INTRO("resons",setup);
	UG_INTRO("inputsig",inputsig);
	UG_INTRO("noise",noise);
	UG_INTRO("buzz",buzzit);
	UG_INTRO("pulse",pulseit);
	UG_INTRO("envelope",sl);
	
	p[0]=1; p[1]=10; p[2]=1024; p[3]=1;
	makegen(p,4);  /* store sinewave in array 1 */
	p[0]=2; p[1]=7; p[2]=512; p[3]=0; p[4]=512; p[5]=1; 
	makegen(p,6);
}
