#import "Ellipse.h"
#define MAXSECTS 24
struct coefs {
	float coef1[MAXSECTS];
	float coef2[MAXSECTS];
	float coef3[MAXSECTS];
	float coef4[MAXSECTS];
	float past1[MAXSECTS];
	float past2[MAXSECTS];
	float past3[MAXSECTS];
	float past4[MAXSECTS];
	} coefs;
	
@implementation Ellipse: Object
{
	float xnorm;
	int nsects;
}
+ create {
	id newInstance;
	newInstance = [ self new ];
	return newInstance;
}
-ellpset: (float *)list
{
/* the first argument in the list is the number of sections */
	int m,i,j;
	nsects = (int)list[0];
	if(nsects > MAXSECTS) { 
		printf("sorry, only configured for %d sections\n",MAXSECTS); 
		exit(-4);
	}
		i=1;
	for(m=0;m<nsects;m++) {    
	        	 coefs.coef1[m] = list[i++];
			 coefs.coef2[m] = list[i++];
			 coefs.coef3[m] = list[i++];
			 coefs.coef4[m] = list[i++];
			 coefs.past1[m] = 
			 coefs.past2[m] = 
			 coefs.past3[m] = 
			 coefs.past4[m] = 0; 
		}
	xnorm = list[i];
}
-(float)ellipse :(float) signal
{
	int m;
	float op;

	for(m=0;m<nsects;m++) {
		op = signal + coefs.coef1[m] * coefs.past1[m] 
		            + coefs.coef3[m] * coefs.past2[m]
		            - coefs.coef2[m] * coefs.past3[m] 
		            - coefs.coef4[m] * coefs.past4[m];
		coefs.past2[m] = coefs.past1[m];
		coefs.past1[m] = signal;
		coefs.past4[m] = coefs.past3[m];
		coefs.past3[m] = op;
		signal = op;
		}
	return(signal*xnorm);
}
@end
