#include "../H/sfheader.h"
#include "label.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <signal.h>
#include <errno.h>
#define  BUFSIZE 32768

char tapename[16] = "/dev/nrxt0";
char *usefile;
static SFCODE   ampcode = {
	SF_MAXAMP,
	sizeof(SFMAXAMP) + sizeof(SFCODE)
	}; 

main(argc,argv)

int argc;
char *argv[];

{
	SFHEADER sfh1;
	struct stat sfst1;
	struct mtget mtget ;
	struct mtop mtop ;
	struct label label;

	char *cp,*sfout,*getsfcode();
	char buffer[BUFSIZE];
	int totalbytes,i,result,inbytes,sfile,tapeunit,tapefile,skipfile;
	int tapenumber,headersize;
	float duration;

	if(argc == 1) {
usage:		printf("Usage: -f [device] -l [tape number] -s [tape files to skip over] sf1 .. sfn\nDefaults: /dev/nrmt0, skip over label only\n");
		exit(1);
	}
	usefile = tapename;
	skipfile = tapenumber = 0;
	tapefile = 1;
	system("date");
	while((*++argv)[0] == '-') {
		argc -= 2; /* Take away two args */
		for(cp = argv[0]+1; *cp; cp++) {
			switch(*cp) { /* Grap options */
			case 'f': 
				usefile = *++argv;
				break;
			case 's':
				tapefile = atoi(*++argv)-1;/*account for label*/
				skipfile = tapefile ? 1 : 0;
				/* skip this number of files before writing*/
				break;
			case 'l':
				tapenumber = atoi(*++argv);
				break;
			default:
				printf("unknown option\n");
				goto usage;
			}
		}
	}
	if(!tapenumber) {
		printf("You didn't specify a tape number with -n flag\n");
		exit(-1);
	}
	if((tapeunit = open(usefile,0)) < 0) {
		printf("trouble opening tape unit\n");
		exit(tapeunit);
	}
	if(read(tapeunit,&label,SIZEOFLABEL) != SIZEOFLABEL) {
		printf("Can't seem to read the label on this tape\n");
		exit(tapeunit);
	}
	if(label.tapenumber != tapenumber) {
		printf
		("this is tape number %d, you are asking for tape number %d\n"
		,label.tapenumber,tapenumber);
		exit(tapeunit);
	}
	mtop.mt_op = MTFSF;
	mtop.mt_count = 1;
	if((ioctl(tapeunit,MTIOCTOP,&mtop)) == -1) {
		printf("error forward spacing tape past label eof\n");
		exit(-2);
	}
	printf("Comment on tape %d: %s\n",label.tapenumber,label.comment);
	close(tapeunit);

	for(i=0; i<argc-1; i++) {
		sfout = argv[i];
		if((sfile = open(sfout,O_CREAT | O_RDWR, 0644)) <= 0) {
			printf("Can't open file %s\n");
			exit(1);
		}
		totalbytes = 0;

		if((tapeunit = open(usefile,0)) < 0) {
			printf("trouble opening tape unit\n");
			exit(tapeunit);
		}

		if(skipfile) {
			mtop.mt_op = MTFSF;
			mtop.mt_count = tapefile;
			if((ioctl(tapeunit,MTIOCTOP,&mtop)) == -1) {
				printf("error forward spacing tape\n");
				exit(-2);
			}
		}
		skipfile = 0;
		/* read first record to get header printed up*/
		if((inbytes = read(tapeunit,buffer,BUFSIZE)) != BUFSIZE) {
			printf("Bad read on tape unit %d %d\n",tapeunit,inbytes);
			exit(-1);
		}
		bcopy(buffer,(char *)&sfh1,SIZEOF_BSD_HEADER);
		headersize = getheadersize(&sfh1);
printf("headersize = %d\n",headersize);
		printf("-------------------------------------------------\n");
		newprintsf(&sfh1);

		if((write(sfile,buffer,BUFSIZE)) != BUFSIZE) {
			printf("Bad write on soundfile\n");
			exit(-1);
		}
		totalbytes = BUFSIZE;

		while(1) {
			if((inbytes=read(tapeunit,buffer,BUFSIZE)) <= 0) {
				printf("reached eof on input\n");
				close(sfile);
				break;
			}
			if(write(sfile,buffer,inbytes) != inbytes) {
				printf("Bad write on sound file\n");
				close(sfile);
				close(tapeunit);
				exit(0);
			}
			totalbytes += inbytes;
		}
		duration = 
			(float)totalbytes/(float)sfclass(&sfh1)/
				(float)sfchans(&sfh1)/sfsrate(&sfh1);
		tapefile++;
		printf
		     ("Bytes restored = %d, duration = %f, tapefile = %d\n\n\n",
			totalbytes,duration,tapefile);
		fflush(stdout);
		close(sfile);
		if(i == (argc-2)) {
			mtop.mt_op = MTREW;
			mtop.mt_count = 1;
			if((ioctl(tapeunit,MTIOCTOP,&mtop)) == -1) {
				printf("error rewinding tape\n");
				exit(-2);
			}
		}
		close(tapeunit);
	}
}
newprintsf(header,size)
SFHEADER *header;
int size;
{
	SFMAXAMP sfmnew;
	int i,j;
	char *pointer;
	if(size == SIZEOF_BSD_HEADER) { printsf(header); return; }
	
	if((header)->sfinfo.NeXTheader.magic != SND_MAGIC) return(-1);
	/* this is a next soundfile so zero out bytes after NeXT header */
	pointer = (char *)header;
	for(j=29; j<i; j++)  *(pointer+j) = 0;
	(header)->sfinfo.sf_srate = (header)->sfinfo.NeXTheader.samplingRate;
	(header)->sfinfo.sf_chans = (header)->sfinfo.NeXTheader.channelCount;
	if((header)->sfinfo.NeXTheader.dataFormat == SND_FORMAT_FLOAT)
 		(header)->sfinfo.sf_packmode = SF_FLOAT;
	else if((header)->sfinfo.NeXTheader.dataFormat == SND_FORMAT_LINEAR_16)
		(header)->sfinfo.sf_packmode = SF_SHORT;
	for(i=0; i<2 /*(header)->sfinfo.sf_chans*/; i++) {
		sfmaxamp(&sfmnew,i)=0;
		sfmaxamploc(&sfmnew,i)=0;
	}
	sfmaxamptime(&sfmnew) = 0;
	putsfcode(header,&sfmnew,&ampcode);
	printsf(header);
	return(2);
}

