

#include <math.h>
#include <stdio.h>

/*
 *  these are important Minc tuning parameters
 */
#define  YYLMAX	2048	  	/* maximum yacc line length          */
#define  MAXDISPARGS  1024	/* max arguments passed to dispatcher*/
#define  EPS          0.0000005 /* epsilon used in float comparisons */
#define  MAXSTACK     15        /* depth of function calls as args   */
#define  HASHSIZE 107		/* number of buckets in string table */


typedef union{
	int ival;
	struct tree *trees;
	char *str;
	} YYSTYPE;

extern  flerror;        /* don't execute if set = 1 */


#define S_LOCAL	 3	/* scopes */
#define S_PARAM  4
#define S_GLOBAL 5
#define S_RESERVED  10  /* the smallest number the newscope returns */
#define T_INT	'i'     /* types */
#define T_FLOAT	'f'
#define T_COND	'?'
#define T_SCALAR 0	/* shapes */
#define T_ARRAY	 1
#define T_FUNC	 2

/* type manipulation macros;  saves bytes in symbol tables */
#define mktype(type, shape) ((type)|(shape)<<8)
#define xtype(type) (type&0177)
#define xshape(type) ((type>>8)&03)

typedef 
struct symbol {			/* symbol table entries */
	struct symbol  *next;	/* next entry on hash chain */
	char *name;	 	/* string name */
	short scope; 		/* scope */
	short type;		/* type */
	union {
		double	fval;	/* floating point value */
		int	ival;	/* integer representation */
		double  (*fnct) ();  /* built in functions */
	} v;

#ifdef never
/* the following are not use at this moment */
	short defined;		/* set when function defined */
	short offset; 		/* offset in activation frame */
	SYMBOL *list; 	/* next parameter in parameter list */
#endif
}SYMBOL;


extern char *emalloc();
extern SYMBOL *lookup();
extern SYMBOL *install();
extern SYMBOL *mnew();
extern char *strsave();

/*
*   intermediate representation
*/


#define	PROC	20
#define	SEQ	21			
#define LABEL	22
#define JUMP	23
#define CJUMP	24
#define OP 	25
#define UNOP	26
#define CONVERT 27
#define FETCH	28
#define STORE	29
#define MOVE	30
#define ESEG	31
#define BOOL	32
#define NAME	33
#define CONST   34
#define CONSTF	35
#define ALLOC	36	
#define TEMP	37
#define CALL	38	
#define CAND	39
#define NOT	40
#define REL	41
#define ARG	42
#define NOARGS 	43	
#define PLUS	44	
#define MINUS	45
#define MUL	46
#define DIV	47
#define MOD	48
#define AND	49	  
#define OR	50
#define LSHIFT	51
#define RSHIFT	52
#define XOR	53
#define EQ	54
#define NEQ	55
#define LT	56
#define GT	57
#define GEQ	58
#define NEG	59
#define COMP	60
#define FREE	66
#define POW	67
#define COR     68
#define TIF	69
#define TWHILE  70
#define TFOR	71
#define TIFELSE 72
#define LEQ     73
#define CVTCO   74
#define CVTCL	75
#define CVTOL	76
#define CVTOC	77
#define CVTLC	78
#define CVTLO	79
#define TNOOP   80




typedef struct tree {
  char	op;	/* the operator */
  char 	kind;   /* what kind of node is this */
  char	type;	/* at execution time: type of value*/
  union {
    char   *fctname;    /* name to  dispatcher function */
    
  } x;
  union {
    double  fval;
    int 	ival;
    
  }v;
  union {
    struct tree  *child[4];
    SYMBOL *sym;
    int  	ival;
    double fval;            /* If you're having strange problems with */
  }u;                       /* args ... change here to float fval */
}*Tree;


extern Tree  	program;        /* return value of yyparse           */ 	




