/*
*  this file contains the following error functions:
*  sys_error (msg)
*  i_error (msg)
*  yyerror (msg)
*  i_warning (msg)
*  msg(msg)
*/

#include <stdio.h>
#include "defs.h"

int yylineno;

sys_error (msg)
char *msg;
{
fprintf (stderr,"FATAL SYSTEM ERROR: %s\n",msg);  
exit (1);
}

i_error (msg)
char *msg;
{
fprintf (stderr,"FATAL PROGRAM ERROR: %s\n",msg);  
exit (1);
}

i_warning (msg)
char *msg;
{
fprintf (stderr,"warning from program: %s\n",msg);  
}

msg (msg)
char *msg;
{
fprintf (stderr,"%s\n",msg);  
exit (1);
}

yyerror (msg)
char *msg;
{
fprintf (stderr,"near line %d: %s\n",yylineno,msg);  
}
