#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

/* am -- amplitude modulate an input signal
*
*  p0 = input skip
*  p1 = output skip
*  p2 = duration
*  p3 = amplitude
*  p4 = AM modulator frequency (hz)
*  p5 = input channel [optional]
*  p6 = stereo spread <0-1> [optional]
*  assumes function table 1 is the amplitude envelope
*  function table 2 is the AM modulator waveform
*
*/

#define ARRSIZE 16384

extern SFHEADER      sfdesc[NFILES];

double
am(p,n_args)
float p[];
int n_args;
{
	long i,nsamps,n,m,count,smps = 0;
	float amp,val,phase,si;
	float xin[2*ARRSIZE],out[2*ARRSIZE];
	float *amtable;
	int lenam;
	float *amparr,amptabs[2];
	int lenamp;
	int j,skip,inchans,outchans,inchan;
	extern int resetval;

	setnote(p[0],p[2],0);
	nsamps = setnote(p[1],p[2],1);

	amparr = floc(1);
	lenamp = fsize(1);
	tableset(p[2], lenamp, amptabs);

        amtable = floc(2);
	lenam = fsize(2);
        si = p[4] * (float)lenam/SR;

	inchans = sfchans(&sfdesc[0]);
	outchans = sfchans(&sfdesc[1]);
	skip = SR/(float)resetval;
	inchan = p[5];
        j = 0;
        amp = p[3];
	phase = 0.0;
	for (i = nsamps; i > 0; i -= ARRSIZE) {
		count = (i < ARRSIZE) ? i : ARRSIZE;
		count *= inchans;
		bgetin(xin,0,count);
		m = 0;
		for (n = 0; n < count; n += inchans) {
			while (!j--) {
				val = tablei(smps,amparr,amptabs) * amp;
				j = skip;
				smps += skip;
				}
			out[m] = xin[n+inchan] * oscili(val, si, amtable, lenam, &phase);

			if (outchans > 1) {
				out[m+1] = (1.0 - p[6]) * out[m];
				out[m] *= p[6];
				}
			m += outchans;
			}
		baddout(out,1,count*outchans/inchans);
		}
	endnote(1);
}



int NBYTES = 16384;

profile()
{
	UG_INTRO("am",am);
	UG_INTRO("reset",reset);
}
