#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include <stdio.h>

extern SFHEADER      sfdesc[NFILES];

/* sculpt: instrument for tracking audiosculpt data placed in makegens
*
*  p0 = start time
*  p1 = duration of each point
*  p2 = overall amplitude
*  p3 = number of points
*  p4 = stereo spread (0-1) <optional>
*  function slot 1 is waveform, slot 2 is overall amp envelope
*  function slot 3 is frequency points, slot 4 is amplitude points
*/

double sculpt(p,n_args)
float p[];
int n_args;
{
	int i,nsamps,len;
	float tdur;
	int pdur;
	float out[2];
	float si, *wave, *amptable, phase, amptabs[2];
	float *freqtable, *pamptable;
	float overamp,amp;
	int pcount, chans, index;

	tdur = p[1] * p[3];
	nsamps = setnote(p[0], tdur, 1);
	pdur = p[1] * SR;

	wave = floc(1);      /* set pointer to data in makegen slot 1 */
	len = fsize(1);

	amptable = floc(2);
	tableset(tdur, fsize(2), amptabs);
	freqtable = floc(3);
	pamptable = floc(4);

	/* si= freq * size /SR */

	chans = sfchans(&sfdesc[1]); /* get file number of channels */
	phase = 0;
	pcount = 0;
	index = 0;
	for (i = 0; i < nsamps; i++ ) {
		while (!pcount--) {
			si = freqtable[index] * (float)len/SR;
			overamp = table(i, amptable, amptabs) * p[2];
			amp = ampdb(60.0 + pamptable[index]) * overamp;
			index++;
			pcount = pdur;
			}

		out[0] = oscili(amp, si, wave, len, &phase);

		if (chans > 1) { /* split stereo files between the channels */
			out[1] = (1.0 - p[4]) * out[0];
			out[0] *= p[4];
			}

		ADDOUT(out, 1);
		}
	endnote(1);
}


int NBYTES = 32768;
 
profile()
{
	UG_INTRO("sculpt",sculpt);
}
