#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
#define maxdl 14000
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq delayq1;
extern  strumq strumq1;

pickup(p,n_args)
 
 /* Plucked string instrument using strum.
    Models pickup position.
    Use with start.c to initialize notes.       
    Analog of fret.c

    start(start time, dur, pitch, tf0, tNy, fractional distance along string of          pickup.)

    tf0 is the decay time at the fundamental frequency of the note.
    tNy is high freq decay time.
    squish is an integer 0 or greater that specifies how 'squishy' the
      plucking implement is.  0 is a hard implement.  5 is more like a finger.

    tNy is normally a lot smaller than tf0.
    */



 float *p;
 int n_args;
  {
  float freq,out[4],strum(),delf,delay();
  int squish;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;

  nsamps=setnote(p[0],p[1],1);

  freq=cpspch(p[2]);
   
  sset(freq,p[3],p[4],&strumq1);

  delf = freq/p[5];
printf("%f,%f",delf,freq);

  delayset(delf,&delayq1);

  for (i=0;i<nsamps;i++) {
      out[0]=strum(0.,&strumq1);
      out[0] -= delay(out[0],&delayq1);
      ADDOUT(out,1);
      }
  
  endnote(1);
}
