/*
 * addrtInst()
 *	Function: Introduce a new rt creation func/object to CMIX 
 *	Args:	rt_item structure
 *	Calls:	nothing
 *	Return:	0 on success, -1 on failure
 *  -------> BGG: add these and "mixerr.h" later
 *		MX_FEXIST - ugen by that name already exists
 *		MX_EMEM	  - No memory to create ug_item
 *	Side Effects:
 */
#include "../rtstuff/Instrument.h"
#include "../rtstuff/rt.h"
#include "mixerr.h"
#include <string.h>

addrtInst(rt_item *rt_p)
{
	rt_item *rt_tail;

	/*  Seek end of rt_list	*/
	rt_tail = rt_list;
	if (!rt_tail) { // first one on the list
		rt_list = rt_p;
		return 0;
		}
	for (rt_tail=rt_list; rt_tail->rt_next; rt_tail=rt_tail->rt_next)
	{
		if (!strcmp((char *)rt_tail,rt_p->rt_name))	{
			mixerr = MX_FEXIST;
			return (-1);
		}
	}
	rt_tail->rt_next = rt_p;
	rt_p->rt_next = NULL;
	return (0);
}
