#include <unistd.h>
#include "../rtstuff/rtdefs.h"

extern int audio_on; /* defined in rtinput.c */
extern short inbuff[]; /* defined in ../Minc/traverse.C */

int rtgetin(float *inarr, int fdesc, int nsmps)
{
	int nbytes;
	int i;
	short in[2*RTBUFSAMPS];

	if (fdesc == AUDIO_DEVICE) {
		for (i = 0; i < nsmps; i++) inarr[i] = inbuff[i];
		return(0);
		}

	nbytes = read(fdesc, (void *)in, nsmps*sizeof(short));

	for (i = 0; i < nsmps; i++) inarr[i] = in[i];

	if (nbytes < 0) {
		for (i = 0; i < nsmps; i++) inarr[i] = 0.0;
		}

	return(nbytes);
}

