#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "../H/sfheader.h"

extern int print_is_on;
extern float SR;

/* This stuff not yet in LINUX */

#ifdef sgi
ALport in_port;
int audio_on = 0;
int audioNCHANS; /* this is for the reads on the audio device */
#endif

int input_on;
double inSR;
int inNCHANS;
char *rtsfname;

/* this routine is used in the Minc score to open up a file for
*  subsequent reads by RT Instruments.  "rtsetinput" is usein
* in the init member functions of the Instruments to access the
* file.
*
* if p[0] is "AUDIO" and if [optional] p1 is "MIC", "LINE" or "DIGITAL"
* it will set up the input device to do real-time reading of sound
* [optional] p[2] is nchans for input (default is stereo)
*
* p[0] = input soundfile name; p[1] = "MIC", "LINE", or "DIGITAL" (if
* p[0] == "AUDIO"); p[2] = (optional) input chans for real-time audio
*
*
*  DT:  2/4/97:  Not yet in LINUX
*/

double rtinput(float *p, short n_args, double *pp)
{
#ifdef sgi
	AFfilehandle rtinfile;
	ALconfig in_port_config;
#endif

	int i,sf,result,headersize;
        struct stat sfst;
	float dur;
	SFHEADER sfh;

	int tint;	

	/* Here is a fine example of cmix's ancient legacy. */
	/* Since we're casting stuff into doubles, which */
	/* are sometimes pointers to char's ... we need to */
	/* be sure that "bringing them back down" works */
	/* tint used to be an int ... which is to say that if */
	/* the double represented by pp[0] was too big, due to */
	/* variations in memory addressing by compilers, etc... */
	/* you'd be screwed.  So we make it into a long, to */
	/* provide a higher degree of "safety." */

	/* Thanks to Brad Garton for explaining that to me. */
	/* DT 2/10/97 */

        tint = (int)pp[0];
        rtsfname = (char *)tint;
   
	/* Input from soundfile / not audio device ... yet */
	input_on = 0;	

	/* open the file */
	/* using the built-in cmix macros in sfheader.h */
	readopensf(rtsfname,sf,sfh,sfst,"head",result);

	inSR = sfsrate(&sfh);
	inNCHANS = sfchans(&sfh);

	if (inSR != SR) {
		fprintf(stderr, "WARNING: the input file sampling rate is %f; but the output rate is currently %f\n",inSR, SR);
		}


	printf("Input file %s set for reading\n",rtsfname);
	printf("	SR: %f		nchannels: %d\n",inSR,inNCHANS);

	/* we reopen the file in setinput.C to get a unique file desc */
	close(sf);

	return(0.0);
}







