C
C-----------------------------------------------------------------------
C MAIN PROGRAM: MAIN LINE PROGRAM TO COMPUTE THE COMPLEX CEPSTRUM
C               OF A REAL SEQUENCE X(N)
C AUTHORS:      JOSE M. TRIBOLET
C               INSTITUTO SUPERIOR TECNICO, LISBON, PORTUGAL
C               THOMAS F. QUATIERI
C               M.I.T., CAMBRIDGE, MASS. 02139
C-----------------------------------------------------------------------
C
      DIMENSION X(1024), CX(1026), AUX(1026), SPECM(12), SPECP(12)
      COMMON PI, TWOPI, THLINC, THLCON, NFFT, NPTS, N, L, H, H1, DVTMN2
      LOGICAL ISSUC
C
C DIMENSION REQUIREMENTS:
C
C (SEE SUBROUTINE CCEPS)
C
C DESCRIPTION OF ARRAYS:
C
C     X = ARRAY CONTAINING THE SEQUENCE X(N)
C    CX = ARRAY CONTAINING THE COMPLEX CEPSTRUM OF X(N)
C   AUX = AUXILIARY ARRAY
C SPECM = MAGNITUDES OF SPECTRAL ZEROS (SEE COEFF)
C SPECP = PHASE OF SPECTRAL ZEROS (SEE COEFF)
C
C DESCRIPTION OF VARIABLES:
C
C  IOUTD = OUTPUT DEVICE NUMBER
C     NX = LENGTH OF THE SEQUENCE X(N)
C   NFFT = LENGTH OF THE FFT
C THLINC = PHASE INCREMENT THRESHOLD(USED TO OBTAIN MORE
C          CONFIDENT PHASE ESTIMATE NEAR SHARP ZEROS)
C THLCON = PHASE CONSISTENCY THRESHOLD
C  ISSUC = .TRUE. IF COMPLEX CEPSTRUM SUCCESSFULLY COMPUTED;
C          .FALSE. OTHERWISE(PHASE ESTIMATION INCOMPLETE)
C
C SUBROUTINES CALLED:
C
C COEFF = SUBROUTINE TO COMPUTE A SEQUENCE X(N),BY
C         PRESCRIBING ITS SPECTRAL ZEROS
C CCEPS = SUBROUTINE TO COMPUTE THE COMPLEX CEPSTRUM
C         OF A REAL SEQUENCE X(N)
C
C
C
C SET LENGTH OF FFT,THRESHOLD LEVELS,AND OTHER CONSTANTS
C
      IOUTD = I1MACH(2)
      NFFT = 1024
      THLINC = 1.5
      THLCON = .5
      PI = 4.*ATAN(1.)
      TWOPI = 2.*PI
C
C GENERATE THE TEST SIGNAL WITH ZEROS AT:
C
C !0.9!EXP(+/-JPI/4)
C !1.1!EXP(+/-J(PI/4+PI/8192))
C !0.9!EXP(+/-J(PI/4+2*PI/8192))
C
C ***************************************
C *                                     *
C *       P L E A S E    N O T E        *
C *                                     *
C *    USER IS STRONGLY ENCOURAGED TO   *
C *    RUN TEST PROGRAM WITH A VARIETY  *
C *    OF TEST SIGNALS TO BECOME FULLY  *
C *    ACQUAINTED WITH THIS PROGRAM'S   *
C *    CAPABILITIES.PHASE UNWRAPPING    *
C *    MAY OFTEN BE NOT POSSIBLE DUE    *
C *    EITHER TO THEORETICAL REASONS    *
C *    (ZEROS ON THE UNIT CIRCLE )      *
C *    OR TO COMPUTATIONAL REASONS      *
C *    (ZEROS TOO CLOSE TO UNIT CIRCLE) *
C *                                     *
C ***************************************
C
      NX = 6
      SPECM(1) = .9
      SPECP(1) = (PI/4.)
      SPECM(2) = 1.1
      SPECP(2) = (PI/4.+PI/8192.)
      SPECM(3) = .9
      SPECP(3) = (PI/4.+TWOPI/8192.)
      CALL COEFF(NX, X, SPECM, SPECP)
C
C WRITE INPUT DATA SPECIFICATIONS
C
      WRITE (IOUTD,9999)
9999  FORMAT (1X, 10X, 35H*** CCMAIN- TEST PROGRAM OUTPUT ***//)
      WRITE (IOUTD,9998) NX
9998  FORMAT (1X, 34HINPUT SIGNAL-LENGTH (IN SAMPLES) =, I4/)
      I = NX/4
      J = 4*I
      IF (NX.EQ.J) GO TO 20
      J = J + 4
      K = NX + 1
      DO 10 I=K,J
        X(I) = 0.
  10  CONTINUE
  20  WRITE (IOUTD,9997) (I,X(I),I=1,J)
9997  FORMAT (1X/4(4H  X(, I4, 2H)=, F8.4))
C
C COMPUTE THE COMPLEX CEPSTRUM
C
      CALL CCEPS(NX, X, ISNX, ISFX, ISSUC, CX, AUX)
C
C CHECK WHETHER PHASE UNWRAPPING SUCCESSFUL; IF SO
C WRITE OUT DATA;OTHERWISE STOP!
C
      IF (ISSUC) GO TO 30
      WRITE (IOUTD,9996)
9996  FORMAT (1X///1X, 23HPHASE ESTIMATION FAILED)
      STOP
C
C WRITE SIGN,LINEAR PHASE,AND LAST AND FIRST 32 VALUES OF
C THE COMPLEX CEPSTRUM
C
  30  WRITE (IOUTD,9995) ISNX, ISFX
9995  FORMAT (1X/1X, 5HSIGN=, I2//1X, 13HLINEAR PHASE=, I4//)
      INITL = NFFT - 31
      WRITE (IOUTD,9994)
9994  FORMAT (1X, 17HCOMPLEX CEPSTRUM //)
      WRITE (IOUTD,9993) (I,CX(I),I=INITL,NFFT)
      WRITE (IOUTD,9993) (I,CX(I),I=1,32)
9993  FORMAT (1X/4(4H CX(, I4, 2H)=, F8.4))
      STOP
      END
C
C-----------------------------------------------------------------------
C SUBROUTINE: COEFF
C COMPUTES A SEQUENCE C(N) WITH NC SAMPLES BY PRESCRIBING
C THE MAGNITUDES AND PHASES OF ITS SPECTRAL ZEROS.
C-----------------------------------------------------------------------
C
      SUBROUTINE COEFF(NC, C, SM, SP)
      DOUBLE PRECISION S(2,31), Z1, Z2, Z3, Z4
      REAL M(12), P(12), C(12), SM(1), SP(1)
C
C DESCRIPTION OF ARGUMENTS
C
C NC   -ON INPUT EQUALS THE TOTAL NUMBER OF ZEROS OF C(Z)
C      -ON OUTPUT EQUALS THE SEQUENCE LENGTH
C C    -DSEQUENCE WITH PRESCRIBED Z-TRANSFORM
C M    -ARRAY OF SPECTRAL MAGNITUDES.ONLY ONE ENTRY
C       PER EACH COMPLEX CONJUGATE ZERO PAIR MUST BE SPECIFIED
C P    -ARRAY OF SPECTRAL PHASES IN RADIANS.
C ONLY ONE ENTRY PER EACH COMPLEX CONJUGATE ZERO PAIR MUST
C BE SPECIFIED.
C
      N = NC
      I = 1
      IND = 1
  10  CONTINUE
      M(I) = SM(IND)
      P(I) = SP(IND)
      IND = IND + 1
      IF (P(I).EQ.0.) GO TO 20
      M(I+1) = M(I)
      P(I+1) = -P(I)
      I = I + 1
  20  I = I + 1
      IF (I.LT.N) GO TO 10
      Y = P(1)
      S(1,1) = -DBLE(M(1)*COS(Y))
      S(2,1) = -DBLE(M(1)*SIN(Y))
      S(1,2) = 1.
      S(2,2) = 0.
      IF (N.EQ.1) GO TO 50
      DO 40 J=2,N
        S(1,J+1) = S(1,J)
        S(2,J+1) = S(2,J)
        Y = P(J)
        Z3 = -DBLE(M(J)*COS(Y))
        Z4 = -DBLE(M(J)*SIN(Y))
        DO 30 K=1,J
          M0 = J - K
          M1 = M0 + 1
          Z1 = S(1,M1)
          Z2 = S(2,M1)
          IF (M0.EQ.0) GO TO 30
          S(1,M1) = S(1,M0) + Z1*Z3 - Z2*Z4
          S(2,M1) = S(2,M0) + Z1*Z4 + Z2*Z3
  30    CONTINUE
        S(1,1) = Z1*Z3 - Z2*Z4
        S(2,1) = Z1*Z4 + Z2*Z3
  40  CONTINUE
  50  CONTINUE
      NC = N + 1
      DO 60 I=1,NC
        J = NC - I + 1
        C(I) = S(1,J)
  60  CONTINUE
      C(1) = 1.
      RETURN
      END
C
C-----------------------------------------------------------------------
C SUBROUTINE: CCEPS
C SUBROUTINE TO COMPUTE THE COMPLEX CEPSTRUM OF A SEQUENCE X(N)
C-----------------------------------------------------------------------
C
      SUBROUTINE CCEPS(NX, X, ISNX, ISFX, ISSUC, CX, AUX)
C
C DESCRIPTION OF ARGUMENTS:
C
C    NX = LENGTH OF THE SEQUENCE X(N)
C     X = ARRAY CONTAINING THE SEQUENCE X(N)
C  ISNX = INTEGER VALUE,EITHER +1 OR  -1 DEPENDING
C         ON THE SIGN REVERSAL OF X(N)
C  ISFX = INTEGER VALUE INDICATING THE AMOUNT OF SHIFT
C         ON X(N) DUE TO LINEAR PHASE REMOVAL
C ISSUC = .TRUE. IF PHASE ESTIMATION COMPLETE;
C         .FALSE. OTHERWISE
C    CX = ARRAY CONTAINING THE COMPLEX CEPSTRUM
C   AUX = AUXILIARY ARRAY
C
      DIMENSION X(1), CX(1), AUX(1)
C
C DIMENSION REQUIREMENTS:
C
C NX       .LE. NFFT
C DIM(X)   .LE. NFFT
C DIM(CX)  .GE. NFFT+2
C DIM(AUX) .GE. NFFT+2
C
      COMMON PI, TWOPI, THLINC, THLCON, NFFT, NPTS, N, L, H, H1, DVTMN2
      LOGICAL ISSUC
C
C DESCRIPTION OF VARIABLES:
C
C THLINC = PHASE INCREMENT THRESHOLD(USED TO OBTAIN MORE
C          CONFIDENT ESTIMATE NEAR SHARP ZEROS)
C THLCON = PHASE CONSISTENCY THRESHOLD
C   NFFT = LENGTH OF FFT
C   NPTS = HALF THE LENGTH OF THE FFT
C DVTMN2 = TWICE THE MEAN OF THE PHASE DERIVATIVE
C
C SUBROUTINES CALLED:
C
C FFA,FFS-SUBROUTINES TO COMPUTE FFT AND IFFT (RADIX 2)
C
C FUNCTIONS CALLED:
C
C AMODSQ = FUNCTION TO COMPUTE THE MODULUS
C          SQUARED OF A COMPLEX NUMBER
C PHADVT = FUNCTION TO COMPUTE THE PHASE DERIVATIVE OF
C          A SPECTRAL VALUE
C PPVPHA = FUNCTION TO COMPUTE THE PRINCIPLE VALUE OF THE
C          PHASE OF A SPECTRAL VALUE
C PHAUNW = FUNCTION TO COMPUTE THE UNWRAPPED PHASE OF A
C          SPECTRAL VALUE
C
C INITIALIZATION
C
      NPTS = NFFT/2
      N = 12
      L = 2**N
      H = FLOAT(L)*FLOAT(NFFT)
      H1 = PI/H
      ISSUC = .TRUE.
      ISNX = 1
C
C TRANSFORM X(N) AND NX(N):FFT
C
      DO 10 I=1,NX
        CX(I) = X(I)
        AUX(I) = FLOAT(I-1)*X(I)
  10  CONTINUE
      INITL = NX + 1
      IEND = NFFT + 2
      DO 20 I=INITL,IEND
        CX(I) = 0.0
        AUX(I) = 0.0
  20  CONTINUE
C
C USE RADIX 2 FFT
C
      CALL FFA(CX, NFFT)
      CALL FFA(AUX, NFFT)
C
C CHECK IF SIGN REVERSAL IS REQUIRED
C
      IF (CX(1).LT.0.0) ISNX = -1
C
C COMPUTE MAGNITUDE OF SPECTRUM:STORE IN ODD-INDEXED
C VALUES OF AUX
C COMPUTE PHASE DERIVATIVE OF SPECTRUM:STORE IN EVEN-INDEXED
C VALUES OF AUX
C COMPUTE LINEAR PHASE ESTIMATE(MEAN OF THE PHASE DERIVATIVE):
C STORE TWICE THE ESTIMATE IN DVTMN2
C
      IO = -1
      DVTMN2 = 0.0
      IEND = NPTS + 1
      DO 30 I=1,IEND
        IO = IO + 2
        IE = IO + 1
        AMAGSQ = AMODSQ(CX(IO),CX(IE))
        PDVT = PHADVT(CX(IO),CX(IE),AUX(IO),AUX(IE),AMAGSQ)
        AUX(IO) = AMAGSQ
        AUX(IE) = PDVT
        DVTMN2 = DVTMN2 + PDVT
  30  CONTINUE
      DVTMN2 = (2.*DVTMN2-AUX(2)-PDVT)/FLOAT(NPTS)
C
C COMPUTE LOGMAGNITUDE:STORE IN ODD-INDEXED
C VALUES OF CX
C COMPUTE UNWRAPPED PHASE:STORE IN EVEN-INDEXED
C VALUES OF CX
C
      PPDVT = AUX(2)
      PPHASE = 0.0
      PPV = PPVPHA(CX(1),CX(2),ISNX)
      CX(1) = .5*ALOG(AUX(1))
      CX(2) = 0.0
      IO = 1
      DO 50 I=2,IEND
        IO = IO + 2
        IE = IO + 1
        PDVT = AUX(IE)
        PPV = PPVPHA(CX(IO),CX(IE),ISNX)
        PHASE = PHAUNW(X,NX,ISNX,I,PPHASE,PPDVT,PPV,PDVT,ISSUC)
C
C IF PHASE ESTIMATION SUCCESSFUL,CONTINUE;OTHERWISE RETURN
C
        IF (ISSUC) GO TO 40
        ISSUC = .FALSE.
        RETURN
  40    PPDVT = PDVT
        PPHASE = PHASE
        CX(IO) = .5*ALOG(AUX(IO))
        CX(IE) = PHASE
  50  CONTINUE
C
C REMOVE LINEAR PHASE COMPONENT
C
      ISFX = (ABS(PHASE/PI)+.1)
      IF (PHASE.LT.0.0) ISFX = -ISFX
      H = PHASE/FLOAT(NPTS)
      IE = 0
      DO 60 I=1,IEND
        IE = IE + 2
        CX(IE) = CX(IE) - H*FLOAT(I-1)
  60  CONTINUE
C
C COMPUTE THE COMPLEX CEPSTRUM:IFFT
C
      CALL FFS(CX, NFFT)
      RETURN
      END
C
C-----------------------------------------------------------------------
C SUBROUTINE: SPCVAL
C S                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          