head	1.3;
access;
symbols
	Distribution_06:1.2
	IRT_02:1.1.2.1
	Philips_01:1.1.1.1
	D6Base:1.1
	Distribution_05:1.1
	Distribution_04:1.1
	Distribution_03:1.1
	IRT_01:1.1
	Distribution_01a:1.1
	Distribution_02:1.1;
locks; strict;
comment	@ * @;


1.3
date	96.02.12.07.13.35;	author rowlands;	state Exp;
branches;
next	1.2;

1.2
date	96.01.20.17.13.10;	author rowlands;	state Exp;
branches;
next	1.1;

1.1
date	95.06.16.03.42.42;	author rowlands;	state Exp;
branches
	1.1.1.0
	1.1.2.0
	1.1.3.0;
next	;

1.1.1.0
date	95.11.06.04.11.19;	author rowlands;	state Exp;
branches;
next	1.1.1.1;

1.1.1.1
date	95.11.06.04.12.25;	author rowlands;	state Exp;
branches;
next	;

1.1.2.0
date	95.11.06.04.16.40;	author rowlands;	state Exp;
branches;
next	1.1.2.1;

1.1.2.1
date	95.11.06.04.19.12;	author rowlands;	state Exp;
branches;
next	;

1.1.3.0
date	95.11.06.04.22.32;	author rowlands;	state Exp;
branches;
next	1.1.3.1;

1.1.3.1
date	96.01.19.04.40.26;	author rowlands;	state Exp;
branches;
next	;


desc
@Dynamic crosstalk by IRT
@


1.3
log
@Release following Munich meeting
@
text
@/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Multichannel Encoder
 *
 * $Id: dyn_cross.c 1.2 1996/01/20 17:13:10 rowlands Exp $
 *
 * $Log: dyn_cross.c $
 **********************************************************************/

#include "common.h"
#include "encoder.h"

/************************************************************************
 *
 * take_dyn_cross
 *
 * Version 1.0	    94/10/24	Andreas Silzle, IRT
 *
 * Copy the sums, scf, scfsi, if required, in the normal positions.
 *
 ************************************************************************/


#define LOW_SBGR	5   /* lowest subbandgroup, in which dyn_cross is done.*/
			    /* All sb-groups under that boarder are not	       */
			    /* affected by dyn_cross			       */


void take_dyn_cross(
	int		dyn_cr,	
	frame_params	*fr_ps,  		    
	    /* out: int	fr_ps->header->dyn_cross_on, 
	     *	    int	fr_ps->header->dyn_cross_LR, 
    	     *	    int	fr_ps->header->dyn_cross[SBGRS],	    
	     */			    
	double		sb_sample_sum[4][3][SCALE_BLOCK][SBLIMIT], 	    
						    /* in, T23, T24, T34, T234 */
	unsigned int	scalar_sum[][3][SBLIMIT], 			/* in */ 
	unsigned int	scfsi_sum[][SBLIMIT],  				/* in */
	unsigned int	scfsi_dyn[][SBLIMIT],  				/* in */
	double		sb_sample[CHANMAX2][3][SCALE_BLOCK][SBLIMIT],	/* out */
	unsigned int	scalar[][3][SBLIMIT], 				/* out */ 
	unsigned int	scfsi[][SBLIMIT]) 				/* out */
{
    int	    sbgr, sb, sufr, smp;
    
    fr_ps->header->dyn_cross_on = 0;
    fr_ps->header->dyn_cross_LR = 0;	/* out of L0 */
    
    for(sbgr=LOW_SBGR; sbgr<SBGRS; sbgr++) {
	/* signalization */
	if(dyn_cr == 0) {
	    fr_ps->header->dyn_cross[sbgr] = 0;
	}
	else {
	    fr_ps->header->dyn_cross_on = 1;   
	    fr_ps->header->dyn_cross[sbgr] = dyn_cr;
	    
	    /* copying sums, scf, scfsi */
	    if(fr_ps->header->dyn_cross[sbgr] == 9 || fr_ps->header->dyn_cross[sbgr] == 11) {
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) {
		    scfsi[T2[sbgr]][sb] = scfsi_sum[T23][sb];
		    for(sufr = 0; sufr<3; ++sufr) {
			scalar[T2[sbgr]][sufr][sb] = scalar_sum[T23][sufr][sb];
			for(smp = 0; smp<SCALE_BLOCK; ++smp) {
			    sb_sample[T2[sbgr]][sufr][smp][sb] = 
				sb_sample_sum[T23][sufr][smp][sb];
			}   /* for(smp..) */
		    }	    /* for(sufr.). */
		}	    /* for(sb..) */
	    } 
	    else if(fr_ps->header->dyn_cross[sbgr] == 10 || fr_ps->header->dyn_cross[sbgr] == 12) {
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) {
		    scfsi[T2[sbgr]][sb] = scfsi_sum[T24][sb];
		    for(sufr = 0; sufr<3; ++sufr) {
			scalar[T2[sbgr]][sufr][sb] = scalar_sum[T24][sufr][sb];
			for(smp = 0; smp<SCALE_BLOCK; ++smp) {
			    sb_sample[T2[sbgr]][sufr][smp][sb] = 
				sb_sample_sum[T24][sufr][smp][sb];
			}   /* for(smp..) */
		    }	    /* for(sufr..) */
		}	    /* for(sb..) */
	    } 
	    else if(fr_ps->header->dyn_cross[sbgr] == 8 || fr_ps->header->dyn_cross[sbgr] == 13) {
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) {
		    scfsi[T3[sbgr]][sb] = scfsi_sum[T34][sb];
		    for(sufr = 0; sufr<3; ++sufr) {
			scalar[T3[sbgr]][sufr][sb] = scalar_sum[T34][sufr][sb];
			for(smp = 0; smp<SCALE_BLOCK; ++smp) {
			    sb_sample[T3[sbgr]][sufr][smp][sb] = 
				sb_sample_sum[T34][sufr][smp][sb];
			}   /* for(smp..) */
		    }	    /* for(sufr..) */
		}	    /* for(sb..) */
	    } 
	    else if(fr_ps->header->dyn_cross[sbgr] == 14) {
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) {
		    scfsi[T2[sbgr]][sb] = scfsi_sum[T234][sb];
		    for(sufr = 0; sufr<3; ++sufr) {
			scalar[T2[sbgr]][sufr][sb] = scalar_sum[T234][sufr][sb];
			for(smp = 0; smp<SCALE_BLOCK; ++smp) {
			    sb_sample[T2[sbgr]][sufr][smp][sb] = 
				sb_sample_sum[T234][sufr][smp][sb];
			}   /* for(smp..) */
		    }	    /* for(sufr..) */
		}	    /* for(sb..) */
	    }		    /* if(dyncr_do[sbgr]..) */
    
	    /* scfsi_dyn in scfsi of L0 and R0 */
	    /* T2 */
	    switch(fr_ps->header->dyn_cross[sbgr]) {
	  case 3: case 5: case 6: case 7: case 13:
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) 
		    if(T2[sbgr] == L || fr_ps->header->dyn_cross_LR == 0)
			scfsi[L0][sb] = scfsi_dyn[L0][sb];
		    else 
			scfsi[R0][sb] = scfsi_dyn[R0][sb];
		break;	    
	    }	/* switch(dyncr_do[sbgr]) */
	    /* T3 */
	    switch(fr_ps->header->dyn_cross[sbgr]) {
	  case 2: case 4: case 6: case 7: case 12:
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) 
		    scfsi[L0][sb] = scfsi_dyn[L0][sb];
		break;	    
	    }	/* switch(dyncr_do[sbgr]) */
	    /* T4 */
	    switch(fr_ps->header->dyn_cross[sbgr]) {
	  case 1: case 4: case 5: case 7: case 11:
		for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
			sb<=sb_groups[sbgr]; sb++) 
		    scfsi[R0][sb] = scfsi_dyn[R0][sb];
		break;	    
	    }	/* switch(fr_ps->header->dyn_cross[sbgr]) */
	}	/* if(fr_ps->header->dyn_cross[sbgr] == 0) */
    }		/* for(sbgr=0.. */   
}

/************************************************************************
 *
 * trans_chan
 *
 * Version 1.0	    94/06/27	Andreas Silzle, IRT
 * Version 1.1	    94/10/28	Andreas Silzle, IRT
 *
 * Which channels are in the transmission channels 
 * T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof{SBGRS] per subband group.
 * T2outof[] can be changed later by fr_ps->header->dyn_cross_LR.
 *
 ************************************************************************/

void trans_chan( 
	frame_params	*fr_ps) 		    
	    /* in:  int	fr_ps->header->tc_alloc[SBGRS], 
    	     *	    int	fr_ps->numchan,	    
	     *	    int	fr_ps->header->matrix,	    0 normal -, 3 no matricing 
	     *	    int fr_ps->header->dyn_cross_LR  0 out of L0, 1 out of R0
	     */			    
/*  global parameters
 *  out:    T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof{SBGRS]
 */
{  
    int sbgr;

    
    if((fr_ps->header->matrix == 2) || (fr_ps->header->matrix == 3)) {
	for(sbgr = 0; sbgr < SBGRS; sbgr++) {
	    T2[sbgr] = C; 
	    T3[sbgr] = LS; 
	    T4[sbgr] = RS;
	}
    }
    else {
	for(sbgr = 0; sbgr < SBGRS; sbgr++) {
	    switch(fr_ps->header->tc_alloc[sbgr]) {
	  case 0:
		T2[sbgr] = C; T3[sbgr] = LS; T4[sbgr] = RS;
		if(fr_ps->header->dyn_cross_LR == 0)
		    T2outof[sbgr] = L0;
		else
		    T2outof[sbgr] = R0;
		break;
	  case 1:
		T2[sbgr] = L; T3[sbgr] = LS; T4[sbgr] = RS;
		T2outof[sbgr] = L0;
		break;
	  case 2:
		T2[sbgr] = R; T3[sbgr] = LS; T4[sbgr] = RS;
		T2outof[sbgr] = R0;
		break;
	  case 3:
		T2[sbgr] = C; T3[sbgr] = L; T4[sbgr] = RS;
		if(fr_ps->header->dyn_cross_LR == 0)
		    T2outof[sbgr] = L0;
		else
		    T2outof[sbgr] = R0;
		break;
	  case 4:
		T2[sbgr] = C; T3[sbgr] = LS; T4[sbgr] = R;
		if(fr_ps->header->dyn_cross_LR == 0)
		    T2outof[sbgr] = L0;
		else
		    T2outof[sbgr] = R0;
		break;
	  case 5:
		T2[sbgr] = C; T3[sbgr] = L; T4[sbgr] = R;
		if(fr_ps->header->dyn_cross_LR == 0)
		    T2outof[sbgr] = L0;
		else
		    T2outof[sbgr] = R0;
		break;
	  case 6:
		T2[sbgr] = R; T3[sbgr] = L; T4[sbgr] = RS;
		T2outof[sbgr] = R0;
		break;
	  case 7:
		T2[sbgr] = L; T3[sbgr] = LS; T4[sbgr] = R;
		T2outof[sbgr] = L0;
		break;
	    }	/* switch() */
	}	/* for(sbgr.. */
    }		/* if(fr_ps.. */
}

/************************************************************************
 *
 * combine
 *
 * Version 1.0	    94/06/27	Andreas Silzle, IRT
 *
 * Add two channels into a mono channel to use it in dynamic crosstalk.
 *
 ************************************************************************/

void combine( 
	frame_params	*fr_ps, 		    
	    /* in:  int	fr_ps->header->tc_alloc[SBGRS], 
	     *	    int fr_ps->sblimit,			
	     */
	double	sb_sample[CHANMAX2][3][SCALE_BLOCK][SBLIMIT],	/* in */
	double	sb_sample_sum[4][3][SCALE_BLOCK][SBLIMIT]) 	
		    /* out; T23, T24, T34, T234 */
{  
/*  global parameters
 *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS]
 *      sb_groups[SBGRS]
 */
    int sb, sbgr, smp, sufr;

    for(sbgr=0; sbgr<SBGRS; sbgr++) {
	for(sb=((sbgr==0) ? 0:(sb_groups[sbgr-1]+1)); 
		sb<=sb_groups[sbgr]; sb++) {
	    for(smp = 0; smp<SCALE_BLOCK; smp++) {
		for(sufr = 0; sufr<3; ++sufr) {
		    sb_sample_sum[T23][sufr][smp][sb] = 
			.5 * (sb_sample[T2[sbgr]][sufr][smp][sb]
			    + sb_sample[T3[sbgr]][sufr][smp][sb]);
		    sb_sample_sum[T24][sufr][smp][sb] = 
			.5 * (sb_sample[T2[sbgr]][sufr][smp][sb]
			    + sb_sample[T4[sbgr]][sufr][smp][sb]);
		    sb_sample_sum[T34][sufr][smp][sb] = 
			.5 * (sb_sample[T3[sbgr]][sufr][smp][sb]
			    + sb_sample[T4[sbgr]][sufr][smp][sb]);
		    sb_sample_sum[T234][sufr][smp][sb] = 
			.333333 * (sb_sample[T2[sbgr]][sufr][smp][sb]
			    + sb_sample[T3[sbgr]][sufr][smp][sb]
			    + sb_sample[T4[sbgr]][sufr][smp][sb]);
		}   /* for(sufr.. */
	    }	    /* for(smp.. */
	}	    /* for(sb.. */
    }		    /* for(sbgr.. */	
}

/****************************************************************************
 *
 *  void dyn_bal
 *
 *  Add the bits for scf and scfsi of the channel with dynamic crosstalk
 *  in the case of min_ch is L0 and R0.
 *
 *  07/94	Susanne Ritscher
 *  94/10/28	Andreas Silzle	    little remake
 *
 *****************************************************************************/

void dyn_bal(
	unsigned int	scfsi[CHANMAX2][SBLIMIT],   /* in */ 
	int		sbgr,			    /* in */
	frame_params	*fr_ps,
	    /* in:  fr_ps->header->dyn_cross[sbgr] */
	int		min_ch,			    /* in */
	int		min_sb,			    /* in */
	int		*seli,			    /* in, out */
	int		*scale)			    /* in, out */
{
/*  global parameters
 *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS]	
 */
    static int	sfsPerScfsi[] = { 3,2,1,2 };    /* lookup # sfs per scfsi */

    switch(fr_ps->header->dyn_cross[sbgr]) {
  case 0:	
	break;	    /* no additional scf and scfsi */
  case 1:  
	if(min_ch == R0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 2:  
	if(min_ch == L0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	break;
  case 3: 
	if(min_ch == T2outof[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];
	}
	break;
  case 4: 
	if(min_ch == L0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	if(min_ch == R0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 5:  
	if(min_ch == T2outof[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];
	}
	if(min_ch == R0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 6: 
	if(min_ch == T2outof[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];
	}
	if(min_ch == L0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	break;
  case 7: 
	if(min_ch == T2outof[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];
	}
	if(min_ch == L0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	if(min_ch == R0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 8:
	if(min_ch == T3[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 9:  
	if(min_ch == T2[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	break;
  case 10:  
	if(min_ch == T2[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 11:  
	if(min_ch == T2[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	if(min_ch == R0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 12:  
	if(min_ch == T2[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	if(min_ch == L0) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	}
	break;
  case 13:  
	if(min_ch == T2outof[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T2[sbgr]][min_sb]];
	}
	if(min_ch == T3[sbgr]) {
	    *seli += 2;
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 14:  
	if(min_ch == T2[sbgr]) {
	    *seli += 4;
	    *scale += 6 * sfsPerScfsi[scfsi[T3[sbgr]][min_sb]];
	    *scale += 6 * sfsPerScfsi[scfsi[T4[sbgr]][min_sb]];
	}
	break;
  case 15: 
	fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");
	fflush(stderr);
	exit(0);
	break;
    }	    /* switch.. */
}


/****************************************************************************
 *
 *  void choose_dyn
 *
 *  bit_alloc of the dynamic crosstalk channels must be have a value; 
 *  only for sending scf in datastream.
 *
 *  07/94	Susanne Ritscher
 *  94/10/31	Andreas Silzle	    little remake
 *  94/12/30	Andreas Silzle	    
 *		    fill only up to that subband of the basic channel
 *		    which is unequal zero.
 *
 *****************************************************************************/

void choose_dyn(
	frame_params	*fr_ps, 
	    /* in:  fr_ps->header->dyn_cross[sbgr] 
	     *	    fr_ps->alloc
	     */
	int		min_ch,				/* in */
	int		min_sb,				/* in */
	int		sbgr, 				/* in */
	unsigned int	bit_alloc[CHANMAX2][SBLIMIT])	/* out */
{
/*  global parameters
 *  in:	T2[SBGRS], T3[SBGRS], T4[SBGRS], T2outof[SBGRS]
 */

    switch(fr_ps->header->dyn_cross[sbgr]) {
  case 0:	
	break;
  case 1: 
	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
  case 2: 
	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	break;
  case 3: 
	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0)
	       bit_alloc[T2[sbgr]][min_sb] = 1;
	break;
  case 4: 
	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	break;
  case 5: 
	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) 
	    bit_alloc[T2[sbgr]][min_sb] = 1;
	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) 
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
  case 6: 
	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) 
	    bit_alloc[T2[sbgr]][min_sb] = 1;
	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0) 
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	break;
  case 7: 
	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) 
	    bit_alloc[T2[sbgr]][min_sb] = 1;
	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0) 
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0) 
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
  case 8: 
	if(min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
  case 9: 
	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	break;
 case 10: 
	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
 case 11: 
	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	if(min_ch == R0 && bit_alloc[R0][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
 case 12: 
	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	if(min_ch == L0 && bit_alloc[L0][min_sb] != 0)
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	break;
 case 13: 
	if(min_ch == T2outof[sbgr] && bit_alloc[T2outof[sbgr]][min_sb] != 0) 
	    bit_alloc[T2[sbgr]][min_sb] = 1;
	if(min_ch == T3[sbgr] && bit_alloc[T3[sbgr]][min_sb] != 0)
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	break;
 case 14: 
	if(min_ch == T2[sbgr] && bit_alloc[T2[sbgr]][min_sb] != 0) {
	    bit_alloc[T3[sbgr]][min_sb] = 1;
	    bit_alloc[T4[sbgr]][min_sb] = 1;
	}
	break;
 case 15: 
	fprintf(stderr, "FORBIDDEN DYN_CROSS!!!!!\n");
	fflush(stderr);
	exit(0);
	break;
    }	    /* switch.. */
}


/************************************************************************
 *
 * scfsi_calc_dyn    
 *
 * Version 1.0	    94/07/07	Andreas Silzle, IRT
 *
 * Calculating the scale factor select information of one channel 
 * without changing the scale factors.
 *
 ************************************************************************/

void scfsi_calc_dyn(
	unsigned int	scalar_dyn[][3][SBLIMIT],   /* in/out */
	int		ch, 			    /* in */
	int		sblimit,		    /* in */ 
	unsigned int	scfsi_dyn[][SBLIMIT]) 	    /* out */

{
    int	    sb;
    
    for (sb=0; sb<sblimit; sb++) {
       /* If the subbands are coded only with SCF's, they must be accurate. */
       /* 1993-02-19 and 1994-03-17 shn */
       /* 4 patterns are possible: 0: ABC, 1: AAB, 2: AAA, 3: ABB */
       if ((scalar_dyn[ch][0][sb] != scalar_dyn[ch][1][sb]) &&
           (scalar_dyn[ch][1][sb] != scalar_dyn[ch][2][sb]))
	 scfsi_dyn[ch][sb] = 0;
       else
       if ((scalar_dyn[ch][0][sb] == scalar_dyn[ch][1][sb]) &&
           (scalar_dyn[ch][1][sb] != scalar_dyn[ch][2][sb]))
	 scfsi_dyn[ch][sb] = 1;
       else
       if ((scalar_dyn[ch][0][sb] == scalar_dyn[ch][1][sb]) &&
           (scalar_dyn[ch][1][sb] == scalar_dyn[ch][2][sb]))
	 scfsi_dyn[ch][sb] = 2;
       else
	 scfsi_dyn[ch][sb] = 3;
    }	/* for(sb.. */
}

/************************************************************************
 *
 * scfsi_calc    
 *
 * Version 1.0	    94/07/07	Andreas Silzle, IRT
 *
 * Calculating the scale factor select information of one channel. 
 *
 * route: II_transmission_pattern (Layer II only)
 *
 * PURPOSE:For a given subband, determines whether to send 1, 2, or
 * all 3 of the scalefactors, and fills in the scalefactor
 * select information accordingly
 *
 * SEMANTICS:  The subbands and channels are classified based on how much
 * the scalefactors changes over its three values (corresponding
 * to the 3 sets of 12 samples per subband).  The classification
 * will send 1 or 2 scalefactors instead of three if the scalefactors
 * do not change much.  The scalefactor select information,
 * #scfsi#, is filled in accordingly.
 *
 ************************************************************************/

void scfsi_calc(
	unsigned int	scalar[][3][SBLIMIT], 	/* in/out */
	int		ch, 			/* in */
	int		sblimit,		/* in */ 
	unsigned int	scfsi[][SBLIMIT]) 	/* out */

{
    int dscf[2];
    int class[2], sb, j;
    static int pattern[5][5] = {
	0x123, 0x122, 0x122, 0x133, 0x123,
	0x113, 0x111, 0x111, 0x444, 0x113,
	0x111, 0x111, 0x111, 0x333, 0x113,
	0x222, 0x222, 0x222, 0x333, 0x123,
	0x123, 0x122, 0x122, 0x133, 0x123    };

    for (sb=0; sb<sblimit; sb++) {
	dscf[0] =  (scalar[ch][0][sb]-scalar[ch][1][sb]);
	dscf[1] =  (scalar[ch][1][sb]-scalar[ch][2][sb]);
	for (j=0; j<2; j++) {
	    if (dscf[j]<=-3)
		class[j] = 0;
	    else if (dscf[j] > -3 && dscf[j] <0)
		class[j] = 1;
	    else if (dscf[j] == 0)
		class[j] = 2;
	    else if (dscf[j] > 0 && dscf[j] < 3)
		class[j] = 3;
	    else 
		class[j] = 4;
	}
	switch (pattern[class[0]][class[1]]) {
	case 0x123 :
	    scfsi[ch][sb] = 0;
	    break;
	case 0x122 :
	    scfsi[ch][sb] = 3;
	    scalar[ch][2][sb] = scalar[ch][1][sb];
	    break;
	case 0x133 :
	    scfsi[ch][sb] = 3;
	    scalar[ch][1][sb] = scalar[ch][2][sb];
	    break;
	case 0x113 :
	    scfsi[ch][sb] = 1;
	    scalar[ch][1][sb] = scalar[ch][0][sb];
	    break;
	case 0x111 :
	    scfsi[ch][sb] = 2;
	    scalar[ch][1][sb] = scalar[ch][2][sb] = scalar[ch][0][sb];
	    break;
	case 0x222 :
	    scfsi[ch][sb] = 2;
	    scalar[ch][0][sb] = scalar[ch][2][sb] = scalar[ch][1][sb];
	    break;
	case 0x333 :
	    scfsi[ch][sb] = 2;
	    scalar[ch][0][sb] = scalar[ch][1][sb] = scalar[ch][2][sb];
	    break;
	case 0x444 :
	    scfsi[ch][sb] = 2;
	    if (scalar[ch][0][sb] > scalar[ch][2][sb])
		scalar[ch][0][sb] = scalar[ch][2][sb];
	    scalar[ch][1][sb] = scalar[ch][2][sb] = scalar[ch][0][sb];
	}	/* switch */
    }		/* for(sb.. */
}

/************************************************************************
 *
 * scf_calc    
 *
 * Calculating the scale factor for one channel.
 *
 * Version 1.0	    94/07/07	Andreas Silzle, IRT
 *
 * route: II_scale_factor_calc() 
 *
 * PURPOSE:For each subband, calculate the scale factor for each set
 * of the 12 subband samples
 *
 * SEMANTICS:  Pick the scalefactor #multiple[]# just larger than the
 * absolute value of the peak subband sample of 12 samples,
 * and store the corresponding scalefactor index in #scalar#.
 *
 * Layer II has three sets of 12-subband samples for a given
 * subband.
 *
 ************************************************************************/

void scf_calc(
	double		sample[][3][SCALE_BLOCK][SBLIMIT], /* in */
	int		sblimit,		/* in */
	int		ch,			/* in */
	unsigned int	scf[][3][SBLIMIT])	/* out */ 
{
/* global variables: 
 * double multiple[64] 
 */
    int	    sb, smp, sufr, r;
    double  s[SBLIMIT];

    for (sufr=0; sufr<3; sufr++) {
	for (sb=0; sb<sblimit; sb++)
	    for (smp=1, s[sb] = mod(sample[ch][sufr][0][sb]); 
		    smp<SCALE_BLOCK; smp++)
		if (mod(sample[ch][sufr][smp][sb]) > s[sb])
		    s[sb] = mod(sample[ch][sufr][smp][sb]);
	for (sb=0; sb<sblimit; sb++)
	    for (r=SCALE_RANGE-1, scf[ch][sufr][sb]=0; r>=0; r--)
		if (s[sb] < multiple[r])
		{                       /* <= changed to <, 1992-11-06 shn*/
		    scf[ch][sufr][sb] = r;
		    break;
		}
    }   /* for (sufr.. */
}

@


1.2
log
@Moved Merged into main trunk
@
text
@d2 2
a3 3
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: dyn_cross.c 1.1.3.1 1996/01/19 04:40:26 rowlands Exp $
d5 1
a5 3
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
a7 12
 * Revision 1.1.3.1  1996/01/19  04:40:26  rowlands
 * Merged
 *
 * Revision 1.1.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.1.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
 * Revision 1.1  1995/06/16  03:42:42  rowlands
 * Initial revision
 *
@


1.1
log
@Initial revision
@
text
@d4 1
a4 1
 * $Id: common.c,v 1.3 1995/04/06 04:29:39 rowlands Exp $
d10 13
a22 1
 * $Log: common.c,v $
a328 2
	  /*fprintf(stderr, "[%d][%d] = %d\t", T4[sbgr], min_sb, scfsi[T4[sbgr]][min_sb]); 
	  fflush(stderr);*/
a428 2
	  fprintf(stderr, "[%d][%d] = %d\t", T2[sbgr], min_sb, scfsi[T2[sbgr]][min_sb]); 
	  fflush(stderr);
@


1.1.3.0
log
@Branch for merging IRT_02 and Philips_01
@
text
@d4 1
a4 1
 * $Id: dyn_cross.c 1.1 1995/06/16 03:42:42 rowlands Exp $
d10 1
a10 4
 * $Log: dyn_cross.c $
 * Revision 1.1  1995/06/16  03:42:42  rowlands
 * Initial revision
 *
@


1.1.3.1
log
@Merged
@
text
@d4 1
a4 1
 * $Id: dyn_cross.c 1.1.1.1 1995/11/06 04:12:25 rowlands Exp $
a10 6
 * Revision 1.1.2.1  1995/11/06  04:19:12  rowlands
 * Received from Uwe Felderhoff
 *
 * Revision 1.1.1.1  1995/11/06  04:12:25  rowlands
 * Received from Warner ten Kate
 *
d320 2
d422 2
@


1.1.2.0
log
@Branch for Felderhoff
@
text
@d4 1
a4 1
 * $Id: dyn_cross.c 1.1 1995/06/16 03:42:42 rowlands Exp $
d10 1
a10 4
 * $Log: dyn_cross.c $
 * Revision 1.1  1995/06/16  03:42:42  rowlands
 * Initial revision
 *
@


1.1.2.1
log
@Received from Uwe Felderhoff
@
text
@d320 2
d422 2
@


1.1.1.0
log
@Branch for ten Kate
@
text
@d4 1
a4 1
 * $Id: dyn_cross.c 1.1 1995/06/16 03:42:42 rowlands Exp $
d10 1
a10 4
 * $Log: dyn_cross.c $
 * Revision 1.1  1995/06/16  03:42:42  rowlands
 * Initial revision
 *
@


1.1.1.1
log
@Received from Warner ten Kate
@
text
@@
