/*====================================================================*/
/*         MPEG-4 Audio (ISO/IEC 14496-3) Copyright Header            */
/*====================================================================*/
/*
This software module was originally developed by Rakesh Taori and Andy
Gerrits (Philips Research Laboratories, Eindhoven, The Netherlands) in
the course of development of the MPEG-4 Audio (ISO/IEC 14496-3). This
software module is an implementation of a part of one or more MPEG-4
Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC
14496-3) free license to this software module or modifications thereof
for use in hardware or software products claiming conformance to the
MPEG-4 Audio (ISO/IEC 14496-3). Those intending to use this software
module in hardware or software products are advised that its use may
infringe existing patents. The original developer of this software
module and his/her company, the subsequent editors and their
companies, and ISO/IEC have no liability for use of this software
module or modifications thereof in an implementation. Copyright is not
released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming products.
CN1 retains full right to use the code for his/her own purpose, assign
or donate the code to a third party and to inhibit third parties from
using the code for non MPEG-4 Audio (ISO/IEC 14496-3) conforming
products.  This copyright notice must be included in all copies or
derivative works. Copyright 1996.
*/
/*====================================================================*/
/*====================================================================*/
/*                                                                    */
/*      INCLUDE_FILE:   PHI_P2BS.H                                    */
/*      PACKAGE:        Wdbxx                                         */
/*      COMPONENT:      Parameter to Bitstream converter              */
/*                                                                    */
/*====================================================================*/

/*======================================================================*/
/*      G L O B A L  F U N C T I O N  P R O T O T Y P E S               */
/*======================================================================*/

#ifndef _phi_p2bs_h_
#define _phi_p2bs_h_


#ifdef __cplusplus
extern "C" {
#endif

/*======================================================================*/
/*   Function Prototype: celp_bitstream_mux                             */
/*======================================================================*/
void celp_bitstream_mux(
    const long signal_mode,          /* In: Signal mode (NOT USED)      */
    const long frame_bit_allocation[],/* In: Bit Alloc.                 */ 
	const long interpol,             /* In: Interpolation flag          */
	const long num_lpc_indices,      /* In: Number of packed LPC        */
	const long lpc_indices[],        /* In: LP coefficients             */
	const long rms_index,            /* In: RMS index (NOT USED)        */
	const long shape_indices[],      /* In: Shape indices               */
	const long gain_indices[],       /* In: Gain indices                */
	const long num_shape_cbks,       /* In: Number of shape codebooks   */
	const long num_gain_cbks,        /* In: Number of gain codebooks    */
	const long n_sbfrms,             /* In: Number of subframes         */
	BITSTREAM  * const p_bitstream   /* Out: Bitstream                  */ 
    );

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef _phi_p2bs_h_ */

/*======================================================================*/
/*      H I S T O R Y                                                   */
/*======================================================================*/
/* 07-06-96  R. Taori & A.Gerrits    Initial Version                    */
/* 18-09-96  R. Taori & A.Gerrits    MPEG bitstream used                */

