
/**********************************************************************


This software module was originally developed by

Gerald Schuller (University of Hannover / ACTS-MoMuSys)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. ACTS-MoMuSys partners retain
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.


**********************************************************************/

#include "tf_main.h"
#include "ldfb.h"

extern int LDFB;


void buffer2freq(
  double           p_in_data[], 
  double           p_out_mdct[],
  double           p_overlap[],
  WINDOW_TYPE block_type,
  Window_shape     wfun_select,      /* offers the possibility to select different window functions */
  int              nlong,            /* shift length for long windows   */
  int              nmed,             /* shift length for medium windows */
  int              nshort,           /* shift length for short windows  */
  Mdct_in          overlap_select,   /* select mdct input *TK*          */
                                     /* switch (overlap_select) {       */
                                     /* case OVERLAPPED:                */
                                     /*   p_in_data[]                   */
                                     /*   = overlapped signal           */
                                     /*         (bufferlength: nlong)   */
                                     /* case NON_OVERLAPPED:            */
                                     /*   p_in_data[]                   */
                                     /*   = non overlapped signal       */
                                     /*         (bufferlength: 2*nlong) */
  int              num_short_win,    /* number of short windows to      */
                                     /* transform                       */
  int              save_window       /* save window information         */
)
{
  /*printf("fbencswitch: LDFB= %d \n",LDFB);*/

if(LDFB==0) /*MDCT*/
  {
  buffer2freqMDCT(p_in_data, p_out_mdct, p_overlap,block_type,wfun_select, nlong, nmed, nshort, overlap_select,num_short_win, save_window );
  }
  else /*Low Delay filter bank*/
  {
  if(nlong==2048)  /*Twin-VQ mode*/
    {
    buffer2freqLDTV(p_in_data, p_out_mdct, p_overlap,block_type,wfun_select, nlong, nmed, nshort, overlap_select,num_short_win, save_window );
    }
  else   /*AAC mode */
    {
      /*printf("AAC-mode\n");*/
    buffer2freqLDAAC(p_in_data, p_out_mdct, p_overlap,block_type,wfun_select, nlong, nmed, nshort, overlap_select,num_short_win, save_window );
    }
  }

}
