/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Takeshi Norimatsu,                                                      */
/*   Mineo Tsushima,                                                         */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/* and edited by                                                             */
/*   Akio Jin (NTT),                                                         */
/*   Mineo Tsushima, (Matsushita Electric Industrial Co Ltd.)                */
/*   and Tomokazu Ishikawa (Matsushita Electric Industrial Co Ltd.)          */
/*   on 1997-10-23,                                                          */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"

int mat_scale_set_shift_para(int iscl)
{
	int ii;
	
	switch(mat_shift[iscl])
		{
			case 0: /* 0 to 8kHz */
			ntt_BAND_UPPER_SCL[iscl]=1./3.;
			ntt_BAND_LOWER_SCL[iscl]=0.0;
			/*fprintf(stderr," 0 to 8kHz \n");*/
			break;
			case 1: /* 4kHz to 12kHz */
			ntt_BAND_UPPER_SCL[iscl]=0.5;
			ntt_BAND_LOWER_SCL[iscl]=1./6.;
			/*fprintf(stderr," 4 to 12kHz \n");*/
			break;
			case 2: /* 8kHz to 16kHz */
			ntt_BAND_UPPER_SCL[iscl]=2./3.;
			ntt_BAND_LOWER_SCL[iscl]=1./3.;
			/*fprintf(stderr," 8 to 16kHz \n");*/
			break;
			case 3: /* 16kHz to 24kHz */
			ntt_BAND_UPPER_SCL[iscl]=1.0;
			ntt_BAND_LOWER_SCL[iscl]=2./3.;
			/*fprintf(stderr," 16 to 24kHz \n");*/
			break;
			default:
			fprintf(stderr,"SHIFT Error !! in mat_scale_set_para \n");
			exit(1);
			break;
		}

	/* Long */
	for(ii=0;ii<ntt_N_CRB_48_2048_3rd;ii++){
		ntt_crb_tbl_scl[iscl][ii] = (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR ) + ntt_crb_tbl_48_2048_3rd[ii]); 
	}	
	
	/* Short */
	ntt_N_CRB_S_SCL[iscl]=ntt_N_CRB_S_48_128_3rd;
	
	for(ii=0;ii<ntt_N_CRB_S_SCL[iscl];ii++){
		ntt_crb_tbl_s_scl[iscl][ii] = (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_SHRT ) + ntt_crb_tbl_s_48_128_3rd[ii]); 
	}	

	/* Mid */
	ntt_N_CRB_M_SCL[iscl]=ntt_N_CRB_48_512_3rd;
	for(ii=0;ii<ntt_N_CRB_M_SCL[iscl];ii++){
		ntt_crb_tbl_m_scl[iscl][ii] = (int)(((ntt_BAND_LOWER_SCL[iscl] - ntt_BAND_LOWER_SCL[1])*ntt_N_FR/ntt_N_MID ) + ntt_crb_tbl_48_512_3rd[ii]); 
	}	

	return(0);
}

#ifdef __cplusplus
}
#endif
